/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import org.apache.iotdb.db.concurrent.ThreadName;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.runtime.RPCServiceException;
import org.apache.iotdb.db.service.RPCServiceMBean;
import org.apache.iotdb.db.service.ServiceType;
import org.apache.iotdb.db.service.thrift.ProcessorWithMetrics;
import org.apache.iotdb.db.service.thrift.ThriftService;
import org.apache.iotdb.db.service.thrift.ThriftServiceThread;
import org.apache.iotdb.db.service.thrift.handler.RPCServiceThriftHandler;
import org.apache.iotdb.db.service.thrift.impl.TSServiceImpl;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.service.rpc.thrift.TSIService;

public class RPCService
extends ThriftService
implements RPCServiceMBean {
    private TSServiceImpl impl;

    public static RPCService getInstance() {
        return RPCServiceHolder.INSTANCE;
    }

    @Override
    public ThriftService getImplementation() {
        return RPCService.getInstance();
    }

    @Override
    public void initTProcessor() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.impl = (TSServiceImpl)Class.forName(IoTDBDescriptor.getInstance().getConfig().getRpcImplClassName()).newInstance();
        this.initSyncedServiceImpl(null);
        this.processor = MetricConfigDescriptor.getInstance().getMetricConfig().getEnableMetric() != false ? new ProcessorWithMetrics(this.impl) : new TSIService.Processor((TSIService.Iface)this.impl);
    }

    @Override
    public void initThriftServiceThread() throws IllegalAccessException {
        IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
        try {
            this.thriftServiceThread = new ThriftServiceThread(this.processor, this.getID().getName(), ThreadName.RPC_CLIENT.getName(), config.getRpcAddress(), config.getRpcPort(), config.getRpcMaxConcurrentClientNum(), config.getThriftServerAwaitTimeForStopService(), new RPCServiceThriftHandler(this.impl), IoTDBDescriptor.getInstance().getConfig().isRpcThriftCompressionEnable());
        }
        catch (RPCServiceException e) {
            throw new IllegalAccessException(e.getMessage());
        }
        this.thriftServiceThread.setName(ThreadName.RPC_SERVICE.getName());
    }

    @Override
    public String getBindIP() {
        return IoTDBDescriptor.getInstance().getConfig().getRpcAddress();
    }

    @Override
    public int getBindPort() {
        return IoTDBDescriptor.getInstance().getConfig().getRpcPort();
    }

    @Override
    public ServiceType getID() {
        return ServiceType.RPC_SERVICE;
    }

    @Override
    public int getRPCPort() {
        return this.getBindPort();
    }

    private static class RPCServiceHolder {
        private static final RPCService INSTANCE = new RPCService();

        private RPCServiceHolder() {
        }
    }
}

