/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.core.transformer;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.query.udf.core.executor.UDTFExecutor;
import org.apache.iotdb.db.query.udf.core.reader.LayerPointReader;
import org.apache.iotdb.db.query.udf.core.transformer.Transformer;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public abstract class UDFQueryTransformer
extends Transformer {
    protected final UDTFExecutor executor;
    protected final TSDataType udfOutputDataType;
    protected final LayerPointReader udfOutput;
    protected boolean terminated;

    protected UDFQueryTransformer(UDTFExecutor executor) {
        this.executor = executor;
        this.udfOutputDataType = executor.getConfigurations().getOutputDataType();
        this.udfOutput = executor.getCollector().constructPointReaderUsingTrivialEvictionStrategy();
        this.terminated = false;
    }

    @Override
    public boolean isConstantPointReader() {
        return this.udfOutput.isConstantPointReader();
    }

    @Override
    protected boolean cacheValue() throws QueryProcessException, IOException {
        while (!this.cacheValueFromUDFOutput()) {
            if (this.executeUDFOnce() || this.terminate()) continue;
            return false;
        }
        return true;
    }

    protected final boolean cacheValueFromUDFOutput() throws QueryProcessException, IOException {
        if (!this.udfOutput.next()) {
            return false;
        }
        this.cachedTime = this.udfOutput.currentTime();
        if (this.udfOutput.isCurrentNull()) {
            this.currentNull = true;
        } else {
            switch (this.udfOutputDataType) {
                case INT32: {
                    this.cachedInt = this.udfOutput.currentInt();
                    break;
                }
                case INT64: {
                    this.cachedLong = this.udfOutput.currentLong();
                    break;
                }
                case FLOAT: {
                    this.cachedFloat = this.udfOutput.currentFloat();
                    break;
                }
                case DOUBLE: {
                    this.cachedDouble = this.udfOutput.currentDouble();
                    break;
                }
                case BOOLEAN: {
                    this.cachedBoolean = this.udfOutput.currentBoolean();
                    break;
                }
                case TEXT: {
                    this.cachedBinary = this.udfOutput.currentBinary();
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException(this.udfOutputDataType.toString());
                }
            }
        }
        this.udfOutput.readyForNext();
        return true;
    }

    protected abstract boolean executeUDFOnce() throws QueryProcessException, IOException;

    protected final boolean terminate() throws QueryProcessException {
        if (this.terminated) {
            return false;
        }
        this.executor.terminate();
        this.terminated = true;
        return true;
    }

    @Override
    public final TSDataType getDataType() {
        return this.udfOutputDataType;
    }
}

