/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class AppendTemplatePlan
extends PhysicalPlan {
    String name;
    boolean isAligned;
    String[] measurements;
    TSDataType[] dataTypes;
    TSEncoding[] encodings;
    CompressionType[] compressors;

    public AppendTemplatePlan() {
        super(Operator.OperatorType.APPEND_TEMPLATE);
    }

    public AppendTemplatePlan(String name, boolean isAligned, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors) {
        super(Operator.OperatorType.APPEND_TEMPLATE);
        this.name = name;
        this.isAligned = isAligned;
        this.measurements = measurements.toArray(new String[0]);
        this.dataTypes = dataTypes.toArray(new TSDataType[0]);
        this.encodings = encodings.toArray(new TSEncoding[0]);
        this.compressors = compressors.toArray(new CompressionType[0]);
    }

    public AppendTemplatePlan(String name, boolean isAligned, String[] measurements, TSDataType[] dataTypes, TSEncoding[] encodings, CompressionType[] compressors) {
        super(Operator.OperatorType.APPEND_TEMPLATE);
        this.name = name;
        this.isAligned = isAligned;
        this.measurements = measurements;
        this.dataTypes = dataTypes;
        this.encodings = encodings;
        this.compressors = compressors;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isAligned() {
        return this.isAligned;
    }

    public List<String> getMeasurements() {
        return Arrays.asList(this.measurements);
    }

    public List<TSDataType> getDataTypes() {
        return Arrays.asList(this.dataTypes);
    }

    public List<TSEncoding> getEncodings() {
        return Arrays.asList(this.encodings);
    }

    public List<CompressionType> getCompressors() {
        return Arrays.asList(this.compressors);
    }

    @Override
    public void serializeImpl(ByteBuffer buffer) {
        buffer.put((byte)PhysicalPlan.PhysicalPlanType.APPEND_TEMPLATE.ordinal());
        ReadWriteIOUtils.write((String)this.name, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((Boolean)this.isAligned, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((int)this.measurements.length, (ByteBuffer)buffer);
        for (String string : this.measurements) {
            ReadWriteIOUtils.write((String)string, (ByteBuffer)buffer);
        }
        ReadWriteIOUtils.write((int)this.dataTypes.length, (ByteBuffer)buffer);
        for (String string : this.dataTypes) {
            ReadWriteIOUtils.write((int)string.ordinal(), (ByteBuffer)buffer);
        }
        ReadWriteIOUtils.write((int)this.encodings.length, (ByteBuffer)buffer);
        for (String string : this.encodings) {
            ReadWriteIOUtils.write((int)string.ordinal(), (ByteBuffer)buffer);
        }
        ReadWriteIOUtils.write((int)this.compressors.length, (ByteBuffer)buffer);
        for (String string : this.compressors) {
            ReadWriteIOUtils.write((int)string.serialize(), (ByteBuffer)buffer);
        }
        buffer.putLong(this.index);
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        int i;
        this.name = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        this.isAligned = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        this.measurements = new String[size];
        for (i = 0; i < size; ++i) {
            this.measurements[i] = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        }
        size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        this.dataTypes = new TSDataType[size];
        for (i = 0; i < size; ++i) {
            this.dataTypes[i] = TSDataType.values()[ReadWriteIOUtils.readInt((ByteBuffer)buffer)];
        }
        size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        this.encodings = new TSEncoding[size];
        for (i = 0; i < size; ++i) {
            this.encodings[i] = TSEncoding.values()[ReadWriteIOUtils.readInt((ByteBuffer)buffer)];
        }
        size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        this.compressors = new CompressionType[size];
        for (i = 0; i < size; ++i) {
            this.compressors[i] = CompressionType.deserialize((byte)((byte)ReadWriteIOUtils.readInt((ByteBuffer)buffer)));
        }
        this.index = buffer.getLong();
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeByte((byte)PhysicalPlan.PhysicalPlanType.APPEND_TEMPLATE.ordinal());
        ReadWriteIOUtils.write((String)this.name, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.isAligned, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.measurements.length, (OutputStream)stream);
        for (String string : this.measurements) {
            ReadWriteIOUtils.write((String)string, (OutputStream)stream);
        }
        ReadWriteIOUtils.write((int)this.dataTypes.length, (OutputStream)stream);
        for (String string : this.dataTypes) {
            ReadWriteIOUtils.write((int)string.ordinal(), (OutputStream)stream);
        }
        ReadWriteIOUtils.write((int)this.encodings.length, (OutputStream)stream);
        for (String string : this.encodings) {
            ReadWriteIOUtils.write((int)string.ordinal(), (OutputStream)stream);
        }
        ReadWriteIOUtils.write((int)this.compressors.length, (OutputStream)stream);
        for (String string : this.compressors) {
            ReadWriteIOUtils.write((int)string.serialize(), (OutputStream)stream);
        }
        stream.writeLong(this.index);
    }

    public List<PartialPath> getPaths() {
        return null;
    }
}

