/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.logfile;

import java.io.File;
import java.io.IOException;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.writelog.io.SingleFileLogReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MLogReader
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(MLogReader.class);
    private File logFile;
    SingleFileLogReader singleFileLogReader;

    public MLogReader(String schemaDir, String logFileName) throws IOException {
        File metadataDir = SystemFileFactory.INSTANCE.getFile(schemaDir);
        if (!metadataDir.exists()) {
            logger.error("no mlog.bin to init MManager.");
            throw new IOException("mlog.bin does not exist.");
        }
        this.logFile = SystemFileFactory.INSTANCE.getFile(schemaDir + File.separator + logFileName);
        this.singleFileLogReader = new SingleFileLogReader(this.logFile);
    }

    public MLogReader(String logFilePath) throws IOException {
        this.logFile = SystemFileFactory.INSTANCE.getFile(logFilePath);
        this.singleFileLogReader = new SingleFileLogReader(this.logFile);
    }

    public MLogReader(File logFile) throws IOException {
        this.logFile = logFile;
        this.singleFileLogReader = new SingleFileLogReader(this.logFile);
    }

    public boolean hasNext() {
        return !this.singleFileLogReader.isFileCorrupted() && this.singleFileLogReader.hasNext();
    }

    public PhysicalPlan next() {
        return this.singleFileLogReader.next();
    }

    @Override
    public void close() {
        this.singleFileLogReader.close();
    }

    public boolean isFileCorrupted() {
        return this.singleFileLogReader.isFileCorrupted();
    }
}

