/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.doublelive;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.doublelive.OperationSyncLogService;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.writelog.io.SingleFileLogReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OperationSyncProtector
implements Runnable {
    protected static final Logger LOGGER = LoggerFactory.getLogger(OperationSyncProtector.class);
    protected static final int LOG_FILE_VALIDITY = IoTDBDescriptor.getInstance().getConfig().getOperationSyncLogValidity();
    protected final Lock logFileListLock = new ReentrantLock();
    protected List<String> registeredLogFiles = new ArrayList<String>();
    protected List<String> processingLogFiles;
    private static final int MAX_PHYSICALPLAN_SIZE = 0x1000000;
    protected final ByteArrayOutputStream protectorByteStream = new ByteArrayOutputStream(0x1000000);
    protected final DataOutputStream protectorDeserializeStream = new DataOutputStream(this.protectorByteStream);
    protected volatile boolean isProtectorAtWork = false;

    protected OperationSyncProtector() {
    }

    protected void registerLogFile(String logFile) {
        this.logFileListLock.lock();
        try {
            this.registeredLogFiles.add(logFile);
        }
        finally {
            this.logFileListLock.unlock();
        }
    }

    protected void wrapLogFiles() {
        this.processingLogFiles = new ArrayList<String>(this.registeredLogFiles);
        this.registeredLogFiles = new ArrayList<String>();
    }

    @Override
    public void run() {
        while (true) {
            block8: {
                block7: {
                    this.logFileListLock.lock();
                    try {
                        if (this.registeredLogFiles.size() > 0) {
                            this.isProtectorAtWork = true;
                            this.wrapLogFiles();
                            break block7;
                        }
                        this.isProtectorAtWork = false;
                        break block8;
                    }
                    finally {
                        this.logFileListLock.unlock();
                    }
                }
                if (!this.isProtectorAtWork) continue;
                this.transmitLogFiles();
                continue;
            }
            try {
                TimeUnit.SECONDS.sleep(LOG_FILE_VALIDITY);
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.warn("OperationSyncProtector been interrupted", (Throwable)e);
                continue;
            }
            break;
        }
    }

    protected void transmitLogFiles() {
        this.preCheck();
        for (String logFileName : this.processingLogFiles) {
            SingleFileLogReader logReader;
            File logFile = SystemFileFactory.INSTANCE.getFile(logFileName);
            try {
                logReader = new SingleFileLogReader(logFile);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("OperationSyncProtector can't open OperationSyncLog: {}, discarded", (Object)logFile.getAbsolutePath(), (Object)e);
                continue;
            }
            LOGGER.info("begin trans " + logFileName);
            while (logReader.hasNext()) {
                PhysicalPlan nextPlan = logReader.next();
                try {
                    nextPlan.serialize(this.protectorDeserializeStream);
                }
                catch (IOException e) {
                    LOGGER.error("OperationSyncProtector can't serialize PhysicalPlan", (Throwable)e);
                    continue;
                }
                ByteBuffer nextBuffer = ByteBuffer.wrap(this.protectorByteStream.toByteArray());
                this.protectorByteStream.reset();
                this.transmitPhysicalPlan(nextBuffer, nextPlan);
            }
            LOGGER.info("end trans " + logFileName);
            logReader.close();
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException e) {
                LOGGER.warn("OperationSyncProtector is interrupted", (Throwable)e);
            }
            OperationSyncLogService.incLogFileSize(-logFile.length());
            boolean deleted = false;
            for (int retryCnt = 0; retryCnt < 5; ++retryCnt) {
                if (logFile.delete()) {
                    deleted = true;
                    LOGGER.info("OperationSyncLog: {} is deleted.", (Object)logFile.getAbsolutePath());
                    break;
                }
                LOGGER.warn("Delete OperationSyncLog: {} failed. Retrying", (Object)logFile.getAbsolutePath());
            }
            if (deleted) continue;
            OperationSyncLogService.incLogFileSize(logFile.length());
            LOGGER.error("Couldn't delete OperationSyncLog: {}", (Object)logFile.getAbsolutePath());
        }
    }

    protected abstract void preCheck();

    protected abstract void transmitPhysicalPlan(ByteBuffer var1, PhysicalPlan var2);
}

