/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf.rest;

import java.io.IOException;
import org.apache.iotdb.db.conf.rest.IoTDBRestServiceConfig;
import org.apache.iotdb.db.conf.rest.IoTDBRestServiceDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBRestServiceCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBRestServiceCheck.class);
    private static final IoTDBRestServiceConfig CONFIG = IoTDBRestServiceDescriptor.getInstance().getConfig();

    public static IoTDBRestServiceCheck getInstance() {
        return IoTDBRestServiceConfigCheckHolder.INSTANCE;
    }

    public void checkConfig() throws IOException {
        if (CONFIG.getRestServicePort() > 65535 || CONFIG.getRestServicePort() < 1024) {
            this.printErrorLogAndExit("rest_service_port");
        }
        if (CONFIG.getIdleTimeoutInSeconds() <= 0) {
            this.printErrorLogAndExit("idle_timeout_in_seconds");
        }
        if (CONFIG.getCacheExpireInSeconds() <= 0) {
            this.printErrorLogAndExit("cache_expire_in_seconds");
        }
        if (CONFIG.getCacheMaxNum() <= 0) {
            this.printErrorLogAndExit("cache_max_num");
        }
        if (CONFIG.getCacheInitNum() <= 0) {
            this.printErrorLogAndExit("cache_init_num");
        }
        if (CONFIG.getCacheInitNum() > CONFIG.getCacheMaxNum()) {
            this.printErrorLogAndExit("cache_init_num");
        }
    }

    private void printErrorLogAndExit(String property) {
        LOGGER.error("Wrong config {}, please check!", (Object)property);
        System.exit(-1);
    }

    private static class IoTDBRestServiceConfigCheckHolder {
        private static final IoTDBRestServiceCheck INSTANCE = new IoTDBRestServiceCheck();

        private IoTDBRestServiceConfigCheckHolder() {
        }
    }
}

