/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class MetadataIndexEntry {
    private String name;
    private long offset;

    public MetadataIndexEntry(String name, long offset) {
        this.name = name;
        this.offset = offset;
    }

    public String getName() {
        return this.name;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public String toString() {
        return "<" + this.name + "," + this.offset + ">";
    }

    public int serializeTo(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.writeVar(this.name, outputStream);
        return byteLen += ReadWriteIOUtils.write(this.offset, outputStream);
    }

    public static MetadataIndexEntry deserializeFrom(ByteBuffer buffer) {
        String name = ReadWriteIOUtils.readVarIntString(buffer);
        long offset = ReadWriteIOUtils.readLong(buffer);
        return new MetadataIndexEntry(name, offset);
    }
}

