/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.multipart;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.media.multipart.MultiPartMediaTypes;

public final class Boundary {
    public static final String BOUNDARY_PARAMETER = "boundary";
    private static final AtomicInteger boundaryCounter = new AtomicInteger();

    public static MediaType addBoundary(MediaType mediaType) {
        if (mediaType == null) {
            return MultiPartMediaTypes.createMixed();
        }
        if (!mediaType.getParameters().containsKey(BOUNDARY_PARAMETER)) {
            HashMap<String, String> parameters = new HashMap<String, String>(mediaType.getParameters());
            parameters.put(BOUNDARY_PARAMETER, Boundary.createBoundary());
            return new MediaType(mediaType.getType(), mediaType.getSubtype(), parameters);
        }
        return mediaType;
    }

    public static String createBoundary() {
        return "Boundary_" + boundaryCounter.incrementAndGet() + '_' + new Object().hashCode() + '_' + System.currentTimeMillis();
    }
}

