/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.web;

import org.springframework.beans.BeanUtils;
import org.springframework.test.context.SmartContextLoader;
import org.springframework.test.context.support.AbstractDelegatingSmartContextLoader;
import org.springframework.test.context.web.AnnotationConfigWebContextLoader;
import org.springframework.test.context.web.GenericXmlWebContextLoader;
import org.springframework.util.ClassUtils;

public class WebDelegatingSmartContextLoader
extends AbstractDelegatingSmartContextLoader {
    private static final String GROOVY_XML_WEB_CONTEXT_LOADER_CLASS_NAME = "org.springframework.test.context.web.GenericGroovyXmlWebContextLoader";
    private static final boolean groovyPresent = ClassUtils.isPresent((String)"groovy.lang.Closure", (ClassLoader)WebDelegatingSmartContextLoader.class.getClassLoader()) && ClassUtils.isPresent((String)"org.springframework.test.context.web.GenericGroovyXmlWebContextLoader", (ClassLoader)WebDelegatingSmartContextLoader.class.getClassLoader());
    private final SmartContextLoader xmlLoader;
    private final SmartContextLoader annotationConfigLoader;

    public WebDelegatingSmartContextLoader() {
        if (groovyPresent) {
            try {
                Class loaderClass = ClassUtils.forName((String)GROOVY_XML_WEB_CONTEXT_LOADER_CLASS_NAME, (ClassLoader)WebDelegatingSmartContextLoader.class.getClassLoader());
                this.xmlLoader = (SmartContextLoader)BeanUtils.instantiateClass((Class)loaderClass);
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Failed to enable support for Groovy scripts; could not load class: org.springframework.test.context.web.GenericGroovyXmlWebContextLoader", ex);
            }
        } else {
            this.xmlLoader = new GenericXmlWebContextLoader();
        }
        this.annotationConfigLoader = new AnnotationConfigWebContextLoader();
    }

    @Override
    protected SmartContextLoader getXmlLoader() {
        return this.xmlLoader;
    }

    @Override
    protected SmartContextLoader getAnnotationConfigLoader() {
        return this.annotationConfigLoader;
    }
}

