/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.fory.exception.DeserializationException;
import org.apache.fory.io.ForyStreamReader;
import org.apache.fory.memory.ByteBufferUtil;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.memory.Platform;
import org.apache.fory.util.Preconditions;

@NotThreadSafe
public class ForyReadableChannel
implements ForyStreamReader,
ReadableByteChannel {
    private final ReadableByteChannel channel;
    private final MemoryBuffer memoryBuffer;
    private ByteBuffer byteBuffer;

    public ForyReadableChannel(ReadableByteChannel channel) {
        this(channel, ByteBuffer.allocateDirect(4096));
    }

    public ForyReadableChannel(ReadableByteChannel channel, ByteBuffer directBuffer) {
        Preconditions.checkArgument(directBuffer.isDirect(), "ForyReadableChannel support only direct ByteBuffer.");
        this.channel = channel;
        this.byteBuffer = directBuffer;
        this.memoryBuffer = MemoryBuffer.fromDirectByteBuffer(directBuffer, 0, this);
    }

    @Override
    public int fillBuffer(int minFillSize) {
        try {
            ByteBuffer byteBuf = this.byteBuffer;
            MemoryBuffer memoryBuf = this.memoryBuffer;
            int position = byteBuf.position();
            int newLimit = position + minFillSize;
            if (newLimit > byteBuf.capacity()) {
                int newSize = newLimit < 0x6400000 ? newLimit << 2 : (int)Math.min((double)newLimit * 1.5, 2.147483647E9);
                ByteBuffer newByteBuf = ByteBuffer.allocateDirect(newSize);
                byteBuf.position(0);
                newByteBuf.put(byteBuf);
                byteBuf = this.byteBuffer = newByteBuf;
                memoryBuf.initDirectBuffer(ByteBufferUtil.getAddress(byteBuf), position, byteBuf);
            }
            byteBuf.limit(newLimit);
            int readCount = this.channel.read(byteBuf);
            memoryBuf.increaseSize(readCount);
            return readCount;
        }
        catch (IOException e) {
            throw new DeserializationException("Failed to read the provided byte channel", (Throwable)e);
        }
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int length = dst.remaining();
        MemoryBuffer buf = this.memoryBuffer;
        int remaining = buf.remaining();
        if (remaining >= length) {
            buf.read(dst, length);
            return length;
        }
        buf.read(dst, remaining);
        return this.channel.read(dst) + remaining;
    }

    @Override
    public void readTo(byte[] dst, int dstIndex, int length) {
        MemoryBuffer buf = this.memoryBuffer;
        int remaining = buf.remaining();
        if (remaining >= length) {
            buf.readBytes(dst, dstIndex, length);
        } else {
            buf.readBytes(dst, dstIndex, remaining);
            try {
                ByteBuffer buffer = ByteBuffer.wrap(dst, dstIndex + remaining, length - remaining);
                this.channel.read(buffer);
            }
            catch (IOException e) {
                throw new DeserializationException("Failed to read the provided byte channel", (Throwable)e);
            }
        }
    }

    @Override
    public void readToUnsafe(Object target, long targetPointer, int numBytes) {
        MemoryBuffer buf = this.memoryBuffer;
        int remaining = buf.remaining();
        if (remaining < numBytes) {
            this.fillBuffer(numBytes - remaining);
        }
        long address = buf.getUnsafeReaderAddress();
        Platform.copyMemory(null, address, target, targetPointer, numBytes);
        buf.increaseReaderIndex(numBytes);
    }

    @Override
    public void readToByteBuffer(ByteBuffer dst, int length) {
        MemoryBuffer buf = this.memoryBuffer;
        int remaining = buf.remaining();
        if (remaining >= length) {
            buf.read(dst, length);
        } else {
            buf.read(dst, remaining);
            try {
                int dstLimit = dst.limit();
                int newLimit = dst.position() + length - remaining;
                if (dstLimit > newLimit) {
                    dst.limit(newLimit);
                    this.channel.read(dst);
                    dst.limit(dstLimit);
                } else {
                    this.channel.read(dst);
                }
            }
            catch (IOException e) {
                throw new DeserializationException("Failed to read the provided byte channel", (Throwable)e);
            }
        }
    }

    @Override
    public int readToByteBuffer(ByteBuffer dst) {
        MemoryBuffer buf = this.memoryBuffer;
        int remaining = buf.remaining();
        if (remaining > 0) {
            buf.read(dst, remaining);
        }
        try {
            return this.channel.read(dst) + remaining;
        }
        catch (IOException e) {
            throw new DeserializationException("Failed to read the provided byte channel", (Throwable)e);
        }
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public MemoryBuffer getBuffer() {
        return this.memoryBuffer;
    }
}

