/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.storage.redis.store;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.seata.common.exception.RedisException;
import org.apache.seata.common.exception.StoreException;
import org.apache.seata.common.util.BeanUtils;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.core.model.GlobalStatus;
import org.apache.seata.core.store.BranchTransactionDO;
import org.apache.seata.core.store.GlobalTransactionDO;
import org.apache.seata.server.storage.redis.JedisPooledFactory;
import org.apache.seata.server.storage.redis.LuaParser;
import org.apache.seata.server.storage.redis.store.RedisLuaTransactionStoreManager;
import org.apache.seata.server.storage.redis.store.RedisTransactionStoreManager;
import org.apache.seata.server.store.TransactionStoreManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

public class RedisLuaTransactionStoreManager
extends RedisTransactionStoreManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisLuaTransactionStoreManager.class);
    private static final String LUA_PREFIX = "lua/redisStore/";
    private static final String INSERT_TRANSACTION_DO_LUA_FILE_NAME = "lua/redisStore/insertTransactionDO.lua";
    private static final String DELETE_TRANSACTION_DO_LUA_FILE_NAME = "lua/redisStore/deleteTransactionDO.lua";
    private static final String UPDATE_BRANCH_TRANSACTION_DO_LUA_FILE_NAME = "lua/redisStore/updateBranchTransactionDO.lua";
    private static final String UPDATE_GLOBAL_TRANSACTION_DO_LUA_FILE_NAME = "lua/redisStore/updateGlobalTransactionDO.lua";
    private static final String ROLLBACK_GLOBAL_TRANSACTION_DO_LUA_FILE_NAME = "lua/redisStore/rollbackGlobalTransactionDO.lua";
    private static final Map<String, String> LOCK_SHA_MAP = new HashMap();

    private void initRedisMode() {
        this.loadLuaFile(INSERT_TRANSACTION_DO_LUA_FILE_NAME, "insertTransactionDO");
        this.loadLuaFile(DELETE_TRANSACTION_DO_LUA_FILE_NAME, "deleteTransactionDO");
        this.loadLuaFile(UPDATE_BRANCH_TRANSACTION_DO_LUA_FILE_NAME, "updateBranchTransactionDO");
        this.loadLuaFile(UPDATE_GLOBAL_TRANSACTION_DO_LUA_FILE_NAME, "updateGlobalTransactionDO");
        this.loadLuaFile(ROLLBACK_GLOBAL_TRANSACTION_DO_LUA_FILE_NAME, "rollbackGlobalTransactionDO");
    }

    private void loadLuaFile(String fileName, String mode) {
        block3: {
            try {
                LOCK_SHA_MAP.putAll(LuaParser.getEvalShaMapFromFile((String)fileName));
            }
            catch (IOException e) {
                if (LOCK_SHA_MAP.get(fileName) != null) {
                    LOCK_SHA_MAP.remove(fileName);
                }
                if (!LOGGER.isInfoEnabled()) break block3;
                LOGGER.info("redis session: {} use pipeline mode", (Object)mode);
            }
        }
    }

    public RedisLuaTransactionStoreManager() {
        LOGGER.info("init redisLuaTransactionStoreManager");
        this.initRedisMode();
    }

    public void initGlobalMap() {
        if (CollectionUtils.isEmpty((Map)branchMap)) {
            globalMap = ImmutableMap.builder().put((Object)TransactionStoreManager.LogOperation.GLOBAL_ADD, arg_0 -> this.insertGlobalTransactionDO(arg_0)).put((Object)TransactionStoreManager.LogOperation.GLOBAL_UPDATE, arg_0 -> this.updateGlobalTransactionDO(arg_0)).put((Object)TransactionStoreManager.LogOperation.GLOBAL_REMOVE, arg_0 -> this.deleteGlobalTransactionDO(arg_0)).build();
        }
    }

    public void initBranchMap() {
        if (CollectionUtils.isEmpty((Map)branchMap)) {
            branchMap = ImmutableMap.builder().put((Object)TransactionStoreManager.LogOperation.BRANCH_ADD, arg_0 -> this.insertBranchTransactionDO(arg_0)).put((Object)TransactionStoreManager.LogOperation.BRANCH_UPDATE, arg_0 -> this.updateBranchTransactionDO(arg_0)).put((Object)TransactionStoreManager.LogOperation.BRANCH_REMOVE, arg_0 -> this.deleteBranchTransactionDO(arg_0)).build();
        }
    }

    protected boolean insertBranchTransactionDO(BranchTransactionDO branchTransactionDO) {
        boolean bl;
        block10: {
            String branchKey = this.buildBranchKey(branchTransactionDO.getBranchId());
            String branchListKey = this.buildBranchListKeyByXid(branchTransactionDO.getXid());
            Date now = new Date();
            branchTransactionDO.setGmtCreate(now);
            branchTransactionDO.setGmtModified(now);
            Map branchTransactionDOMap = BeanUtils.objectToMap((Object)branchTransactionDO);
            String luaSHA = (String)LOCK_SHA_MAP.get(INSERT_TRANSACTION_DO_LUA_FILE_NAME);
            if (luaSHA == null) {
                return super.insertBranchTransactionDO(branchTransactionDO);
            }
            Jedis jedis = JedisPooledFactory.getJedisInstance();
            try {
                1 keys = new /* Unavailable Anonymous Inner Class!! */;
                2 args = new /* Unavailable Anonymous Inner Class!! */;
                for (Map.Entry entry : branchTransactionDOMap.entrySet()) {
                    keys.add((String)entry.getKey());
                    args.add((String)entry.getValue());
                }
                LuaParser.jedisEvalSha((Jedis)jedis, (String)luaSHA, (String)INSERT_TRANSACTION_DO_LUA_FILE_NAME, (List)keys, (List)args);
                bl = true;
                if (jedis == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new RedisException((Throwable)ex);
                }
            }
            jedis.close();
        }
        return bl;
    }

    protected boolean deleteBranchTransactionDO(BranchTransactionDO branchTransactionDO) {
        boolean bl;
        block9: {
            String branchKey = this.buildBranchKey(branchTransactionDO.getBranchId());
            String branchListKey = this.buildBranchListKeyByXid(branchTransactionDO.getXid());
            String luaSHA = (String)LOCK_SHA_MAP.get(DELETE_TRANSACTION_DO_LUA_FILE_NAME);
            if (luaSHA == null) {
                return super.deleteBranchTransactionDO(branchTransactionDO);
            }
            Jedis jedis = JedisPooledFactory.getJedisInstance();
            try {
                3 keys = new /* Unavailable Anonymous Inner Class!! */;
                4 args = new /* Unavailable Anonymous Inner Class!! */;
                LuaParser.jedisEvalSha((Jedis)jedis, (String)luaSHA, (String)DELETE_TRANSACTION_DO_LUA_FILE_NAME, (List)keys, (List)args);
                bl = true;
                if (jedis == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new RedisException((Throwable)ex);
                }
            }
            jedis.close();
        }
        return bl;
    }

    protected boolean updateBranchTransactionDO(BranchTransactionDO branchTransactionDO) {
        boolean bl;
        block10: {
            String branchKey = this.buildBranchKey(branchTransactionDO.getBranchId());
            String branchStatus = String.valueOf(branchTransactionDO.getStatus());
            String applicationData = String.valueOf(branchTransactionDO.getApplicationData());
            String luaSHA = (String)LOCK_SHA_MAP.get(UPDATE_BRANCH_TRANSACTION_DO_LUA_FILE_NAME);
            if (luaSHA == null) {
                return super.updateBranchTransactionDO(branchTransactionDO);
            }
            Jedis jedis = JedisPooledFactory.getJedisInstance();
            try {
                5 keys = new /* Unavailable Anonymous Inner Class!! */;
                6 args = new /* Unavailable Anonymous Inner Class!! */;
                String result = (String)LuaParser.jedisEvalSha((Jedis)jedis, (String)luaSHA, (String)UPDATE_BRANCH_TRANSACTION_DO_LUA_FILE_NAME, (List)keys, (List)args);
                LuaParser.LuaResult luaResult = (LuaParser.LuaResult)LuaParser.getObjectFromJson((String)result, LuaParser.LuaResult.class);
                if (!luaResult.getSuccess().booleanValue()) {
                    throw new StoreException("Branch transaction is not exist, update branch transaction failed.");
                }
                bl = true;
                if (jedis == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new RedisException((Throwable)ex);
                }
            }
            jedis.close();
        }
        return bl;
    }

    protected boolean insertGlobalTransactionDO(GlobalTransactionDO globalTransactionDO) {
        boolean bl;
        block10: {
            String globalKey = this.buildGlobalKeyByTransactionId((Object)globalTransactionDO.getTransactionId());
            String globalStatus = this.buildGlobalStatus(globalTransactionDO.getStatus());
            String xid = globalTransactionDO.getXid();
            Date now = new Date();
            globalTransactionDO.setGmtCreate(now);
            globalTransactionDO.setGmtModified(now);
            Map globalTransactionDOMap = BeanUtils.objectToMap((Object)globalTransactionDO);
            String luaSHA = (String)LOCK_SHA_MAP.get(INSERT_TRANSACTION_DO_LUA_FILE_NAME);
            if (luaSHA == null) {
                return super.insertGlobalTransactionDO(globalTransactionDO);
            }
            Jedis jedis = JedisPooledFactory.getJedisInstance();
            try {
                7 keys = new /* Unavailable Anonymous Inner Class!! */;
                8 args = new /* Unavailable Anonymous Inner Class!! */;
                for (Map.Entry entry : globalTransactionDOMap.entrySet()) {
                    keys.add((String)entry.getKey());
                    args.add((String)entry.getValue());
                }
                keys.add("SEATA_BEGIN_TRANSACTIONS");
                args.add(xid);
                args.add(String.valueOf(globalTransactionDO.getBeginTime() + (long)globalTransactionDO.getTimeout().intValue()));
                LuaParser.jedisEvalSha((Jedis)jedis, (String)luaSHA, (String)INSERT_TRANSACTION_DO_LUA_FILE_NAME, (List)keys, (List)args);
                bl = true;
                if (jedis == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new RedisException((Throwable)ex);
                }
            }
            jedis.close();
        }
        return bl;
    }

    protected boolean deleteGlobalTransactionDO(GlobalTransactionDO globalTransactionDO) {
        boolean bl;
        block9: {
            String globalKey = this.buildGlobalKeyByTransactionId((Object)globalTransactionDO.getTransactionId());
            String globalStatus = this.buildGlobalStatus(globalTransactionDO.getStatus());
            String luaSHA = (String)LOCK_SHA_MAP.get(DELETE_TRANSACTION_DO_LUA_FILE_NAME);
            if (luaSHA == null) {
                return super.deleteGlobalTransactionDO(globalTransactionDO);
            }
            Jedis jedis = JedisPooledFactory.getJedisInstance();
            try {
                9 keys = new /* Unavailable Anonymous Inner Class!! */;
                10 args = new /* Unavailable Anonymous Inner Class!! */;
                LuaParser.jedisEvalSha((Jedis)jedis, (String)luaSHA, (String)DELETE_TRANSACTION_DO_LUA_FILE_NAME, (List)keys, (List)args);
                bl = true;
                if (jedis == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new RedisException((Throwable)ex);
                }
            }
            jedis.close();
        }
        return bl;
    }

    protected boolean updateGlobalTransactionDO(GlobalTransactionDO globalTransactionDO) {
        boolean bl;
        block12: {
            String xid = globalTransactionDO.getXid();
            String globalKey = this.buildGlobalKeyByTransactionId((Object)globalTransactionDO.getTransactionId());
            Integer status = globalTransactionDO.getStatus();
            String luaSHA = (String)LOCK_SHA_MAP.get(UPDATE_GLOBAL_TRANSACTION_DO_LUA_FILE_NAME);
            if (luaSHA == null) {
                return super.updateGlobalTransactionDO(globalTransactionDO);
            }
            Jedis jedis = JedisPooledFactory.getJedisInstance();
            try {
                11 keys = new /* Unavailable Anonymous Inner Class!! */;
                12 args = new /* Unavailable Anonymous Inner Class!! */;
                String result = (String)LuaParser.jedisEvalSha((Jedis)jedis, (String)luaSHA, (String)UPDATE_GLOBAL_TRANSACTION_DO_LUA_FILE_NAME, (List)keys, (List)args);
                LuaParser.LuaResult luaResult = (LuaParser.LuaResult)LuaParser.getObjectFromJson((String)result, LuaParser.LuaResult.class);
                if (!luaResult.getSuccess().booleanValue()) {
                    String type = luaResult.getStatus();
                    if ("NotExisted".equals(type)) {
                        throw new StoreException("Global transaction is not exist, update global transaction failed.");
                    }
                    if ("ChangeStatusFail".equals(type)) {
                        String previousStatus = luaResult.getData();
                        GlobalStatus before = GlobalStatus.get((int)Integer.parseInt(previousStatus));
                        GlobalStatus after = GlobalStatus.get((int)status);
                        throw new StoreException("Illegal changing of global status, update global transaction failed. beforeStatus[" + before.name() + "] cannot be changed to afterStatus[" + after.name() + "]");
                    }
                }
                bl = true;
                if (jedis == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (jedis != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new RedisException((Throwable)ex);
                }
            }
            jedis.close();
        }
        return bl;
    }
}

