/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.cluster.raft;

import com.alipay.sofa.jraft.Node;
import com.alipay.sofa.jraft.RaftGroupService;
import com.alipay.sofa.jraft.RouteTable;
import com.alipay.sofa.jraft.StateMachine;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.option.NodeOptions;
import com.alipay.sofa.jraft.rpc.RpcServer;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.rpc.Disposable;
import org.apache.seata.server.cluster.raft.RaftStateMachine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaftServer
implements Disposable,
Closeable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RaftStateMachine raftStateMachine;
    private final String groupId;
    private final String groupPath;
    private final NodeOptions nodeOptions;
    private final PeerId serverId;
    private final RpcServer rpcServer;
    private RaftGroupService raftGroupService;
    private Node node;

    public RaftServer(String dataPath, String groupId, PeerId serverId, NodeOptions nodeOptions, RpcServer rpcServer) throws IOException {
        this.groupId = groupId;
        this.groupPath = dataPath + File.separator + groupId;
        this.raftStateMachine = new RaftStateMachine(groupId);
        this.nodeOptions = nodeOptions;
        this.serverId = serverId;
        this.rpcServer = rpcServer;
    }

    public void start() throws IOException {
        FileUtils.forceMkdir((File)new File(this.groupPath));
        this.nodeOptions.setFsm((StateMachine)this.raftStateMachine);
        this.nodeOptions.setLogUri(this.groupPath + File.separator + "log");
        this.nodeOptions.setRaftMetaUri(this.groupPath + File.separator + "raft_meta");
        this.nodeOptions.setSnapshotUri(this.groupPath + File.separator + "snapshot");
        boolean reporterEnabled = ConfigurationFactory.getInstance().getBoolean("server.raft.reporterEnabled", false);
        this.nodeOptions.setEnableMetrics(reporterEnabled);
        this.raftGroupService = new RaftGroupService(this.groupId, this.serverId, this.nodeOptions, this.rpcServer, true);
        this.node = this.raftGroupService.start(false);
        RouteTable.getInstance().updateConfiguration(this.groupId, this.node.getOptions().getInitialConf());
        boolean sslEnabled = ConfigurationFactory.getInstance().getBoolean("server.raft.ssl.enabled", false);
        if (sslEnabled) {
            this.enableSSL();
        }
        if (reporterEnabled) {
            Slf4jReporter reporter = Slf4jReporter.forRegistry((MetricRegistry)this.node.getNodeMetrics().getMetricRegistry()).outputTo(this.logger).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
            reporter.start((long)ConfigurationFactory.getInstance().getInt("server.raft.reporterInitialDelay", 60), TimeUnit.MINUTES);
        }
    }

    public Node getNode() {
        return this.node;
    }

    public RaftStateMachine getRaftStateMachine() {
        return this.raftStateMachine;
    }

    public PeerId getServerId() {
        return this.serverId;
    }

    @Override
    public void close() {
        this.destroy();
    }

    public void destroy() {
        Optional.ofNullable(this.raftGroupService).ifPresent(r -> {
            r.shutdown();
            try {
                r.join();
            }
            catch (InterruptedException e) {
                this.logger.warn("Interrupted when RaftServer destroying", (Throwable)e);
            }
        });
    }

    private void enableSSL() {
        this.setSystemProperty("bolt.server.ssl.enable", "true");
        this.setSystemProperty("bolt.server.ssl.clientAuth", "true");
        this.setSystemProperty("bolt.client.ssl.enable", "true");
        Configuration instance = ConfigurationFactory.getInstance();
        this.setSystemProperty("bolt.server.ssl.keystore", instance.getConfig("server.raft.ssl.server.keystore.path"));
        this.setSystemProperty("bolt.server.ssl.keystore.password", instance.getConfig("server.raft.ssl.server.keystore.password"));
        this.setSystemProperty("bolt.server.ssl.keystore.type", instance.getConfig("server.raft.ssl.server.keystore.type"));
        this.setSystemProperty("bolt.server.ssl.kmf.algorithm", instance.getConfig("server.raft.ssl.kmfAlgorithm"));
        this.setSystemProperty("bolt.client.ssl.keystore", instance.getConfig("server.raft.ssl.client.keystore.path"));
        this.setSystemProperty("bolt.client.ssl.keystore.password", instance.getConfig("server.raft.ssl.client.keystore.password"));
        this.setSystemProperty("bolt.client.ssl.keystore.type", instance.getConfig("server.raft.ssl.client.keystore.type"));
        this.setSystemProperty("bolt.client.ssl.tmf.algorithm", instance.getConfig("server.raft.ssl.tmfAlgorithm"));
        this.logger.info("Enable ssl communication between raft nodes");
    }

    private void setSystemProperty(String property, String value) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("Configuration value for " + property + " cannot be null or empty");
        }
        System.setProperty(property, value);
    }
}

