/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traverser;

import java.util.LinkedHashMap;
import org.apache.hugegraph.api.graph.GraphAPI;
import org.apache.hugegraph.api.traverser.TraversersAPI;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.constant.Direction;
import org.apache.hugegraph.structure.traverser.PathWithMeasure;

public class RingsAPI
extends TraversersAPI {
    public RingsAPI(RestClient client, String graphSpace, String graph) {
        super(client, graphSpace, graph);
    }

    @Override
    protected String type() {
        return "rings";
    }

    public PathWithMeasure get(Object sourceId, Direction direction, String label, int depth, boolean sourceInRing, long degree, long capacity, long limit) {
        String source = GraphAPI.formatVertexId(sourceId, false);
        RingsAPI.checkPositive(depth, "Max depth of path");
        RingsAPI.checkDegree(degree);
        RingsAPI.checkCapacity(capacity);
        RingsAPI.checkLimit(limit);
        if (sourceInRing) {
            this.client.checkApiVersion("0.40", "source_in_ring arg of ring API");
        }
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("source", source);
        params.put("direction", (Object)direction);
        params.put("label", label);
        params.put("max_depth", depth);
        params.put("source_in_ring", sourceInRing);
        params.put("max_degree", degree);
        params.put("capacity", capacity);
        params.put("limit", limit);
        RestResult result = this.client.get(this.path(), params);
        return (PathWithMeasure)result.readObject(PathWithMeasure.class);
    }
}

