/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.graph;

import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.api.graph.GraphAPI;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.exception.NotAllCreatedException;
import org.apache.hugegraph.rest.RestHeaders;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.constant.Direction;
import org.apache.hugegraph.structure.constant.HugeType;
import org.apache.hugegraph.structure.graph.BatchEdgeRequest;
import org.apache.hugegraph.structure.graph.Edge;
import org.apache.hugegraph.structure.graph.Edges;

public class EdgeAPI
extends GraphAPI {
    public EdgeAPI(RestClient client, String graphSpace, String graph) {
        super(client, graphSpace, graph);
    }

    @Override
    protected String type() {
        return HugeType.EDGE.string();
    }

    public Edge create(Edge edge) {
        RestResult result = this.client.post(this.path(), edge);
        return (Edge)result.readObject(Edge.class);
    }

    public List<String> create(List<Edge> edges, boolean checkVertex) {
        RestHeaders headers = new RestHeaders().add("Content-Encoding", "gzip");
        ImmutableMap params = ImmutableMap.of((Object)"check_vertex", (Object)checkVertex);
        RestResult result = this.client.post(this.batchPath(), edges, headers, (Map<String, Object>)params);
        List ids = result.readList(String.class);
        if (edges.size() != ids.size()) {
            throw new NotAllCreatedException("Not all edges are successfully created, expect '%s', the actual is '%s'", ids, edges.size(), ids.size());
        }
        return ids;
    }

    public List<Edge> update(BatchEdgeRequest request) {
        this.client.checkApiVersion("0.45", "batch property update");
        RestHeaders headers = new RestHeaders().add("Content-Encoding", "gzip");
        RestResult result = this.client.put(this.batchPath(), null, (Object)request, headers);
        return result.readList(this.type(), Edge.class);
    }

    public Edge update(String edgeid, Edge edge) {
        ImmutableMap params = ImmutableMap.of((Object)"action", (Object)"append");
        RestResult result = this.client.put(this.path(), edgeid, (Object)edge, (Map<String, Object>)params);
        return (Edge)result.readObject(Edge.class);
    }

    public Edge append(Edge edge) {
        String id = edge.id();
        ImmutableMap params = ImmutableMap.of((Object)"action", (Object)"append");
        RestResult result = this.client.put(this.path(), id, (Object)edge, (Map<String, Object>)params);
        return (Edge)result.readObject(Edge.class);
    }

    public Edge eliminate(Edge edge) {
        String id = edge.id();
        ImmutableMap params = ImmutableMap.of((Object)"action", (Object)"eliminate");
        RestResult result = this.client.put(this.path(), id, (Object)edge, (Map<String, Object>)params);
        return (Edge)result.readObject(Edge.class);
    }

    public Edge get(String id) {
        RestResult result = this.client.get(this.path(), id);
        return (Edge)result.readObject(Edge.class);
    }

    public Edges list(int limit) {
        return this.list(null, null, null, null, 0, null, limit);
    }

    public Edges list(Object vertexId, Direction direction, String label, Map<String, Object> properties, int offset, String page, int limit) {
        return this.list(vertexId, direction, label, properties, false, offset, page, limit);
    }

    public Edges list(Object vertexId, Direction direction, String label, Map<String, Object> properties, boolean keepP, int offset, String page, int limit) {
        EdgeAPI.checkOffset(offset);
        EdgeAPI.checkLimit(limit, "Limit");
        String vid = GraphAPI.formatVertexId(vertexId, true);
        String props = GraphAPI.formatProperties(properties);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("vertex_id", vid);
        params.put("direction", (Object)direction);
        params.put("label", label);
        params.put("properties", props);
        params.put("keep_start_p", keepP);
        params.put("offset", offset);
        params.put("limit", limit);
        params.put("page", page);
        RestResult result = this.client.get(this.path(), params);
        return (Edges)result.readObject(Edges.class);
    }

    public void delete(String id) {
        this.client.delete(this.path(), id);
    }
}

