/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc;

import java.util.Arrays;
import org.apache.calcite.adapter.jdbc.JdbcRules;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.jdbc.HiveJdbcConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc.JDBCRexCallValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCProjectPushDownRule
extends RelOptRule {
    private static final Logger LOG = LoggerFactory.getLogger(JDBCProjectPushDownRule.class);
    public static final JDBCProjectPushDownRule INSTANCE = new JDBCProjectPushDownRule();

    public JDBCProjectPushDownRule() {
        super(JDBCProjectPushDownRule.operand(HiveProject.class, (RelOptRuleOperand)JDBCProjectPushDownRule.operand(HiveJdbcConverter.class, (RelOptRuleOperandChildren)JDBCProjectPushDownRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
    }

    public boolean matches(RelOptRuleCall call) {
        HiveProject project = (HiveProject)call.rel(0);
        HiveJdbcConverter conv = (HiveJdbcConverter)call.rel(1);
        for (RexNode currProject : project.getProjects()) {
            if (JDBCRexCallValidator.isValidJdbcOperation(currProject, conv.getJdbcDialect())) continue;
            return false;
        }
        return true;
    }

    public void onMatch(RelOptRuleCall call) {
        LOG.debug("JDBCProjectPushDownRule has been called");
        HiveProject project = (HiveProject)call.rel(0);
        HiveJdbcConverter converter = (HiveJdbcConverter)call.rel(1);
        Project newHiveProject = project.copy(project.getTraitSet(), converter.getInput(), project.getProjects(), project.getRowType());
        JdbcRules.JdbcProject newJdbcProject = (JdbcRules.JdbcProject)new JdbcRules.JdbcProjectRule(converter.getJdbcConvention()).convert((RelNode)newHiveProject);
        if (newJdbcProject != null) {
            RelNode converterRes = converter.copy(converter.getTraitSet(), Arrays.asList(newJdbcProject));
            call.transformTo(converterRes);
        }
    }
}

