/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.schema;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.exception.NotSupportException;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.SchemaElement;

public class SchemaAPI
extends API {
    private static final String PATH = "graphspaces/%s/graphs/%s/%s";

    public SchemaAPI(RestClient client, String graphSpace, String graph) {
        super(client);
        this.path(PATH, graphSpace, graph, this.type());
    }

    public Map<String, List<SchemaElement>> list() {
        return this.listJson();
    }

    public Map<String, String> listGroovy() {
        if (this.client.apiVersionLt("0.66")) {
            throw new NotSupportException("schema get api", new Object[0]);
        }
        RestResult result = this.client.get(this.path(), (Map<String, Object>)ImmutableMap.of((Object)"format", (Object)"groovy"));
        return (Map)result.readObject(Map.class);
    }

    public Map<String, Object> listGroovy(String format, boolean attachIdFlag) {
        if (this.client.apiVersionLt("0.66")) {
            throw new NotSupportException("schema get api", new Object[0]);
        }
        RestResult result = this.client.get(this.path(), (Map<String, Object>)ImmutableMap.of((Object)"format", (Object)format, (Object)"attachidflag", (Object)attachIdFlag));
        return (Map)result.readObject(Map.class);
    }

    public Map<String, List<SchemaElement>> listJson() {
        if (this.client.apiVersionLt("0.66")) {
            throw new NotSupportException("schema get api", new Object[0]);
        }
        RestResult result = this.client.get(this.path(), (Map<String, Object>)ImmutableMap.of((Object)"format", (Object)"json"));
        return (Map)result.readObject(Map.class);
    }

    @Override
    protected String type() {
        return "schema";
    }
}

