/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.auth;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.api.auth.AuthAPI;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.auth.User;
import org.apache.hugegraph.structure.constant.HugeType;

public class UserAPI
extends AuthAPI {
    public UserAPI(RestClient client, String graphSpace) {
        super(client, graphSpace);
    }

    @Override
    protected String type() {
        return HugeType.USER.string();
    }

    public User create(User user) {
        RestResult result = this.client.post(this.path(), user);
        return (User)result.readObject(User.class);
    }

    public Map<String, List<Map<String, String>>> createBatch(List<Map<String, String>> data) {
        String path = String.join((CharSequence)"/", this.path(), "batch");
        RestResult result = this.client.post(path, data);
        return (Map)result.readObject(Map.class);
    }

    public User get(Object id) {
        RestResult result = this.client.get(this.path(), UserAPI.formatEntityId(id));
        return (User)result.readObject(User.class);
    }

    public User.UserRole getUserRole(Object id) {
        String formattedId = UserAPI.formatEntityId(id);
        String path = String.join((CharSequence)"/", this.path(), formattedId, "role");
        RestResult result = this.client.get(path);
        return (User.UserRole)result.readObject(User.UserRole.class);
    }

    public List<User> list(int limit) {
        UserAPI.checkLimit(limit, "Limit");
        ImmutableMap params = ImmutableMap.of((Object)"limit", (Object)limit);
        RestResult result = this.client.get(this.path(), (Map<String, Object>)params);
        return result.readList(this.type(), User.class);
    }

    public User update(User user) {
        String id = UserAPI.formatEntityId(user.id());
        RestResult result = this.client.put(this.path(), id, user);
        return (User)result.readObject(User.class);
    }

    public void delete(Object id) {
        this.client.delete(this.path(), UserAPI.formatEntityId(id));
    }
}

