/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.concurrent;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hugegraph.concurrent.AtomicLock;
import org.apache.hugegraph.concurrent.KeyLock;
import org.apache.hugegraph.concurrent.RowLock;

public class LockGroup {
    private final String name;
    private final Map<String, Object> locksMap;

    public LockGroup(String lockGroup) {
        this.name = lockGroup;
        this.locksMap = new ConcurrentHashMap<String, Object>();
    }

    public Lock lock(String lockName) {
        if (!this.locksMap.containsKey(lockName)) {
            this.locksMap.putIfAbsent(lockName, new ReentrantLock());
        }
        return (Lock)this.locksMap.get(lockName);
    }

    public AtomicLock atomicLock(String lockName) {
        if (!this.locksMap.containsKey(lockName)) {
            this.locksMap.putIfAbsent(lockName, new AtomicLock(lockName));
        }
        return (AtomicLock)this.locksMap.get(lockName);
    }

    public ReadWriteLock readWriteLock(String lockName) {
        if (!this.locksMap.containsKey(lockName)) {
            this.locksMap.putIfAbsent(lockName, new ReentrantReadWriteLock());
        }
        return (ReadWriteLock)this.locksMap.get(lockName);
    }

    public KeyLock keyLock(String lockName) {
        if (!this.locksMap.containsKey(lockName)) {
            this.locksMap.putIfAbsent(lockName, new KeyLock());
        }
        return (KeyLock)this.locksMap.get(lockName);
    }

    public KeyLock keyLock(String lockName, int size) {
        if (!this.locksMap.containsKey(lockName)) {
            this.locksMap.putIfAbsent(lockName, new KeyLock(size));
        }
        return (KeyLock)this.locksMap.get(lockName);
    }

    public <K extends Comparable<K>> RowLock<K> rowLock(String lockName) {
        if (!this.locksMap.containsKey(lockName)) {
            this.locksMap.putIfAbsent(lockName, new RowLock());
        }
        Object value = this.locksMap.get(lockName);
        RowLock lock = (RowLock)value;
        return lock;
    }

    public String name() {
        return this.name;
    }
}

