/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.progress;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.hugegraph.loader.constant.Constants;
import org.apache.hugegraph.loader.exception.LoadException;
import org.apache.hugegraph.loader.executor.LoadContext;
import org.apache.hugegraph.loader.executor.LoadOptions;
import org.apache.hugegraph.loader.mapping.InputStruct;
import org.apache.hugegraph.loader.progress.InputItemProgress;
import org.apache.hugegraph.loader.progress.InputProgress;
import org.apache.hugegraph.loader.reader.InputReader;
import org.apache.hugegraph.loader.reader.Readable;
import org.apache.hugegraph.loader.reader.file.FileReader;
import org.apache.hugegraph.loader.util.JsonUtil;
import org.apache.hugegraph.loader.util.LoadUtil;
import org.apache.hugegraph.util.E;

public final class LoadProgress {
    @JsonProperty(value="vertex_progress")
    private long vertexLoaded = 0L;
    @JsonProperty(value="edge_progress")
    private long edgeLoaded = 0L;
    @JsonProperty(value="input_progress")
    private final Map<String, InputProgress> inputProgress = new LinkedHashMap<String, InputProgress>();

    public long vertexLoaded() {
        return this.vertexLoaded;
    }

    public void plusVertexLoaded(long count) {
        this.vertexLoaded += count;
    }

    public long edgeLoaded() {
        return this.edgeLoaded;
    }

    public void plusEdgeLoaded(long count) {
        this.edgeLoaded += count;
    }

    public Map<String, InputProgress> inputProgress() {
        return this.inputProgress;
    }

    public long totalInputRead() {
        long count = 0L;
        for (InputProgress inputProgress : this.inputProgress.values()) {
            Map<String, InputItemProgress> itemProgresses = inputProgress.loadedItems();
            for (InputItemProgress itemProgress : itemProgresses.values()) {
                count += itemProgress.offset();
            }
            if (inputProgress.loadingItems().isEmpty()) continue;
            for (InputItemProgress item : inputProgress.loadingItems().values()) {
                count += item.offset();
            }
        }
        return count;
    }

    public InputProgress addStruct(InputStruct struct) {
        E.checkNotNull((Object)struct, (String)"mapping mapping");
        this.inputProgress.put(struct.id(), new InputProgress(struct));
        return this.inputProgress.get(struct.id());
    }

    public InputProgress get(String id) {
        return this.inputProgress.get(id);
    }

    public void markLoaded(InputStruct struct, InputReader reader, boolean finish) {
        InputProgress progress = this.inputProgress.get(struct.id());
        Readable readable = null;
        if (reader instanceof FileReader) {
            readable = ((FileReader)reader).readable();
        }
        E.checkArgumentNotNull((Object)progress, (String)"Invalid mapping '%s'", (Object[])new Object[]{struct});
        progress.markLoaded(readable, finish);
    }

    public void write(LoadContext context) throws IOException {
        String fileName = LoadProgress.format(context.options(), context.timestamp());
        File file = FileUtils.getFile((String[])new String[]{fileName});
        String json = JsonUtil.toJson(this);
        FileUtils.write((File)file, (CharSequence)json, (Charset)Constants.CHARSET, (boolean)false);
    }

    public static LoadProgress read(File file) throws IOException {
        String json = FileUtils.readFileToString((File)file, (Charset)Constants.CHARSET);
        return JsonUtil.fromJson(json, LoadProgress.class);
    }

    public static LoadProgress parse(LoadOptions options) {
        if (!options.incrementalMode) {
            return new LoadProgress();
        }
        String dir = LoadUtil.getStructDirPrefix(options);
        File dirFile = FileUtils.getFile((String[])new String[]{dir});
        if (!dirFile.exists()) {
            return new LoadProgress();
        }
        File[] subFiles = dirFile.listFiles((d, name) -> name.startsWith("load-progress"));
        if (subFiles == null || subFiles.length == 0) {
            return new LoadProgress();
        }
        List<File> progressFiles = Arrays.asList(subFiles);
        progressFiles.sort(Comparator.comparing(File::getName));
        File lastProgressFile = progressFiles.get(progressFiles.size() - 1);
        try {
            return LoadProgress.read(lastProgressFile);
        }
        catch (IOException e) {
            throw new LoadException("Failed to read progress file", e);
        }
    }

    public static String format(LoadOptions options, String timestamp) {
        String dir = LoadUtil.getStructDirPrefix(options);
        String name = "load-progress_" + timestamp;
        return Paths.get(dir, name).toString();
    }
}

