/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.watch;

import java.util.Objects;
import org.apache.hugegraph.pd.grpc.watch.NodeEventType;

public class NodeEvent {
    private final String graph;
    private final long nodeId;
    private final EventType eventType;

    public NodeEvent(String graph, long nodeId, EventType eventType) {
        this.graph = graph;
        this.nodeId = nodeId;
        this.eventType = eventType;
    }

    public String getGraph() {
        return this.graph;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeEvent nodeEvent = (NodeEvent)o;
        return this.nodeId == nodeEvent.nodeId && Objects.equals(this.graph, nodeEvent.graph) && this.eventType == nodeEvent.eventType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.graph, this.nodeId, this.eventType});
    }

    public String toString() {
        return "NodeEvent{graph='" + this.graph + "', nodeId=" + this.nodeId + ", eventType=" + this.eventType + "}";
    }

    public static enum EventType {
        UNKNOWN,
        NODE_ONLINE,
        NODE_OFFLINE,
        NODE_RAFT_CHANGE,
        NODE_PD_LEADER_CHANGE;


        public static EventType grpcTypeOf(NodeEventType grpcType) {
            switch (grpcType) {
                case NODE_EVENT_TYPE_NODE_ONLINE: {
                    return NODE_ONLINE;
                }
                case NODE_EVENT_TYPE_NODE_OFFLINE: {
                    return NODE_OFFLINE;
                }
                case NODE_EVENT_TYPE_NODE_RAFT_CHANGE: {
                    return NODE_RAFT_CHANGE;
                }
                case NODE_EVENT_TYPE_PD_LEADER_CHANGE: {
                    return NODE_PD_LEADER_CHANGE;
                }
            }
            return UNKNOWN;
        }
    }
}

