/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.client;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.grpc.ManagedChannel;
import io.grpc.stub.AbstractStub;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.hugegraph.pd.client.AbstractClient;
import org.apache.hugegraph.pd.client.Channels;
import org.apache.hugegraph.pd.client.PDConfig;
import org.apache.hugegraph.pd.common.HgAssert;
import org.apache.hugegraph.pd.common.PDRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PDConnectionManager {
    private static final Logger log = LoggerFactory.getLogger(PDConnectionManager.class);
    private static final long WAITING_SECONDS = 3L;
    private static final ExecutorService reconnectExecutor = PDConnectionManager.newFixedThreadPool(1, "pdcm-reconnect-%d");
    private static final ExecutorService taskExecutor = PDConnectionManager.newFixedThreadPool(1, "pdcm-task-%d");
    private final PDConfig config;
    private final Supplier<String> leaderSupplier;
    private final List<Runnable> reconnectionTasks = new CopyOnWriteArrayList<Runnable>();

    private static ExecutorService newFixedThreadPool(int nThreads, String name) {
        return Executors.newFixedThreadPool(nThreads, new ThreadFactoryBuilder().setDaemon(true).setNameFormat(name).build());
    }

    PDConnectionManager(PDConfig config, Supplier<String> leaderSupplier) {
        this.config = config;
        this.leaderSupplier = leaderSupplier;
    }

    public void addReconnectionTask(Runnable task) {
        this.reconnectionTasks.add(task);
    }

    public void forceReconnect() {
        PDConnectionManager.tryTask(reconnectExecutor, this::doReconnect, "Force Reconnection");
    }

    private void doReconnect() {
        log.info("[PDCM] Trying to force reconnect...");
        this.reconnectionTasks.stream().forEach(e -> {
            try {
                log.info("[PDCM] Force reconnection task...");
                e.run();
            }
            catch (Exception ex) {
                log.error("[PDCM] Failed to run the reconnection task, caused by:", (Throwable)ex);
            }
        });
    }

    public <T extends AbstractStub<T>> T newStub(Function<ManagedChannel, T> stubCreator) {
        HgAssert.isArgumentNotNull(stubCreator, (String)"The stub creator can't be null");
        return this.newStub(stubCreator, this.getChannel());
    }

    private <T extends AbstractStub<T>> T newStub(Function<ManagedChannel, T> creator, ManagedChannel channel) {
        return (T)AbstractClient.setAsyncParams((AbstractStub)creator.apply(channel), this.config);
    }

    ManagedChannel getChannel() {
        ManagedChannel channel = null;
        try {
            channel = Channels.getChannel(this.tryGetLeader());
        }
        catch (Exception e) {
            log.error("[PDCM] Failed to get the leader channel, caused by:", (Throwable)e);
            throw new PDRuntimeException(-1, "[PDCM] Failed to get the channel, caused by:", (Throwable)e);
        }
        return channel;
    }

    String tryGetLeader() {
        log.info("[PDCM] Trying to get the PD leader...");
        String leader = PDConnectionManager.tryTask(taskExecutor, () -> this.leaderSupplier.get(), "Getting PD Leader IP");
        if (leader == null) {
            throw new PDRuntimeException(-1, "[PDCM] Failed to get the PD leader.");
        }
        log.info("[PDCM] Get the PD leader: [ {} ]", (Object)leader);
        return leader;
    }

    static void tryTask(ExecutorService executor, Runnable task, String taskName) {
        PDConnectionManager.tryTask(executor, () -> {
            task.run();
            return true;
        }, taskName);
    }

    static <T> T tryTask(ExecutorService executor, Callable<T> task, String taskName) {
        Future<T> future = executor.submit(task);
        T result = null;
        try {
            result = future.get(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error("[PDCM] Task [ {} ] interrupted. error:", (Object)taskName, (Object)e);
        }
        catch (ExecutionException e) {
            log.error("[PDCM] Task [ {} ] execution failed.", (Object)taskName, (Object)e);
        }
        catch (TimeoutException e) {
            log.error("[PDCM] Task [ {} ] did not complete within the specified timeout: [ {} ]", (Object)taskName, (Object)3L);
            future.cancel(true);
        }
        return result;
    }
}

