/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.interceptor;

import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.context.RpcInvokeContext;
import com.alipay.sofa.rpc.context.RpcRunningState;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.tracer.sofatracer.TripleTracerAdapter;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientHeaderClientInterceptor
implements ClientInterceptor {
    public static final Logger LOGGER = LoggerFactory.getLogger(ClientHeaderClientInterceptor.class);

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        if (RpcRunningState.isDebugMode()) {
            LOGGER.info("[1]header send from client:");
        }
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata requestHeader) {
                RpcInvokeContext context = RpcInvokeContext.getContext();
                SofaRequest sofaRequest = (SofaRequest)context.get("_SOFA_REQUEST");
                ConsumerConfig consumerConfig = (ConsumerConfig)context.get("_SOFA_CONSUMER_CONFIG");
                TripleTracerAdapter.beforeSend(sofaRequest, consumerConfig, requestHeader);
                if (RpcRunningState.isDebugMode()) {
                    LOGGER.info("[2]prepare to send from client:{}", (Object)requestHeader);
                }
                super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    public void onHeaders(Metadata responseHeader) {
                        if (RpcRunningState.isDebugMode()) {
                            LOGGER.info("[3]response header received from server:{}", (Object)responseHeader);
                        }
                        super.onHeaders(responseHeader);
                    }

                    public void onMessage(RespT message) {
                        if (RpcRunningState.isDebugMode()) {
                            LOGGER.info("[4]response message received from server:{}", message);
                        }
                        super.onMessage(message);
                    }

                    public void onClose(Status status, Metadata trailers) {
                        if (RpcRunningState.isDebugMode()) {
                            LOGGER.info("[5]response close received from server:{},trailers:{}", (Object)status, (Object)trailers);
                        }
                        super.onClose(status, trailers);
                    }

                    public void onReady() {
                        if (RpcRunningState.isDebugMode()) {
                            LOGGER.info("[5]client is ready");
                        }
                        super.onReady();
                    }
                }, requestHeader);
            }
        };
    }
}

