/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.gridkit.jvmtool.MTable;

public class MBeanHelper {
    public static String FORMAT_TABLE_COLUMN_WIDTH_THRESHOLD = "table.column.maxWidth";
    public static String FORMAT_COMPOSITE_FIELD_WIDTH_THRESHODL = "composite.field.maxWidth";
    private MBeanServerConnection mserver;
    private int widthThresholdTable = 40;
    private int widthThresholdComposite = 1000;
    static Map<String, Object> ARRAY_MAP = new HashMap<String, Object>();
    static Map<String, String> TYPE_MAP;

    public MBeanHelper(MBeanServerConnection connection) {
        this.mserver = connection;
    }

    public void setFormatingOption(String name, Object value) {
        if (FORMAT_TABLE_COLUMN_WIDTH_THRESHOLD.equals(name)) {
            this.widthThresholdTable = (Integer)value;
        } else if (FORMAT_COMPOSITE_FIELD_WIDTH_THRESHODL.equals(name)) {
            this.widthThresholdComposite = (Integer)value;
        }
    }

    private Map<String, MBeanAttributeInfo> getAttributeInfos(ObjectName bean, Collection<String> attrs, boolean read, boolean write) throws IntrospectionException, ReflectionException, InstanceNotFoundException, IOException {
        MBeanInfo mbinfo = this.mserver.getMBeanInfo(bean);
        HashMap<String, MBeanAttributeInfo> attrInfos = new HashMap<String, MBeanAttributeInfo>(attrs.size());
        for (MBeanAttributeInfo attrInfo : mbinfo.getAttributes()) {
            attrInfos.put(attrInfo.getName(), attrInfo);
        }
        for (String attr : attrs) {
            MBeanAttributeInfo ai = (MBeanAttributeInfo)attrInfos.get(attr);
            if (ai == null) {
                throw new IllegalArgumentException("No such attribute '" + attr + "'");
            }
            if (read && !ai.isReadable()) {
                throw new IllegalArgumentException("Attribute '" + attr + "' is write-only");
            }
            if (!write || ai.isWritable()) continue;
            throw new IllegalArgumentException("Attribute '" + attr + "' is not writeable");
        }
        return attrInfos;
    }

    public List<String> getAttibuteList(ObjectName bean) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        MBeanInfo mbinfo = this.mserver.getMBeanInfo(bean);
        ArrayList<String> result = new ArrayList<String>();
        for (MBeanAttributeInfo attrInfo : mbinfo.getAttributes()) {
            if (!attrInfo.isReadable()) continue;
            result.add(attrInfo.getName());
        }
        return result;
    }

    public Map<String, Object> getAttributes(ObjectName bean, Collection<String> attrs) throws InstanceNotFoundException, ReflectionException, IOException {
        HashMap<String, Object> attrValues = new HashMap<String, Object>(attrs.size());
        for (Attribute attr : this.mserver.getAttributes(bean, attrs.toArray(new String[0])).asList()) {
            attrValues.put(attr.getName(), attr.getValue());
        }
        return attrValues;
    }

    public Map<String, String> get(ObjectName bean, Collection<String> attrs) throws Exception {
        Map<String, MBeanAttributeInfo> attrInfos = this.getAttributeInfos(bean, attrs, true, false);
        Map<String, Object> attrRawValues = this.getAttributes(bean, attrs);
        HashMap<String, String> attrValues = new HashMap<String, String>(attrs.size());
        for (String attr : attrs) {
            String attrValue = this.format(attrRawValues.get(attr), attrInfos.get(attr).getType());
            attrValues.put(attr, attrValue);
        }
        return attrValues;
    }

    public void getAsTable(ObjectName bean, Collection<String> attrs, MTable table) throws Exception {
        Map<String, MBeanAttributeInfo> attrInfos = this.getAttributeInfos(bean, attrs, true, false);
        Map<String, Object> attrRawValues = this.getAttributes(bean, attrs);
        for (String attr : attrs) {
            ArrayList<String> header;
            Object td;
            Object v = attrRawValues.get(attr);
            List<String> tableHeader = null;
            ArrayList<String[]> tableRows = new ArrayList<String[]>();
            if (v instanceof CompositeData[]) {
                td = (CompositeData[])v;
                if (((CompositeData[])td).length == 0) continue;
                header = new ArrayList();
                for (String f : td[0].getCompositeType().keySet()) {
                    if (header.contains(f)) continue;
                    header.add(f);
                }
                tableHeader = header;
                for (Object row : td) {
                    tableRows.add(this.formatRow((CompositeData)row, header));
                }
            } else if (v instanceof CompositeData) {
                CompositeData cd = (CompositeData)v;
                header = new ArrayList<String>();
                for (String f : cd.getCompositeType().keySet()) {
                    if (header.contains(f)) continue;
                    header.add(f);
                }
                tableHeader = header;
                tableRows.add(this.formatRow(cd, header));
            } else if (v instanceof TabularData) {
                td = (TabularData)v;
                td.getTabularType().getIndexNames();
                header = new ArrayList<String>(td.getTabularType().getIndexNames());
                for (String f : td.getTabularType().getRowType().keySet()) {
                    if (header.contains(f)) continue;
                    header.add(f);
                }
                tableHeader = header;
                for (String row : td.values()) {
                    tableRows.add(this.formatRow((CompositeData)((Object)row), header));
                }
            } else {
                tableHeader = Collections.singletonList("Value");
                tableRows.add(new String[]{this.formatLine(v, attrInfos.get(attr).getType())});
            }
            ArrayList<String> tableHeader2 = new ArrayList<String>(tableHeader.size() + 2);
            tableHeader2.add(0, "MBean");
            tableHeader2.add(1, "Attribute");
            tableHeader2.addAll(tableHeader);
            String[] hdr = tableHeader2.toArray(new String[0]);
            for (String[] tableRow : tableRows) {
                ArrayList<String> tableCells = new ArrayList<String>(tableRow.length + 2);
                tableCells.add(bean.getCanonicalName());
                tableCells.add(attr);
                tableCells.addAll(Arrays.asList(tableRow));
                table.append(hdr, tableCells.toArray(new String[0]));
            }
        }
    }

    public void set(ObjectName bean, String attr, String value) throws Exception {
        Map<String, MBeanAttributeInfo> attrInfos = this.getAttributeInfos(bean, Collections.singletonList(attr), false, true);
        Object ov = this.convert(value, attrInfos.get(attr).getType());
        this.mserver.setAttribute(bean, new Attribute(attr, ov));
    }

    public String invoke(ObjectName bean, String operation, String ... params) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException, MBeanException {
        MBeanInfo mbinfo = this.mserver.getMBeanInfo(bean);
        MBeanOperationInfo op = null;
        for (MBeanOperationInfo oi : mbinfo.getOperations()) {
            if (!oi.getName().equalsIgnoreCase(operation) || oi.getSignature().length != params.length) continue;
            if (op != null) {
                throw new IllegalArgumentException("Ambiguous " + operation + "/" + params.length + " operatition signature for " + bean);
            }
            op = oi;
        }
        if (op == null) {
            throw new IllegalArgumentException("Operation " + operation + "/" + params.length + " not found for " + bean);
        }
        Object[] args = new Object[params.length];
        String[] sig = new String[params.length];
        for (int i = 0; i != params.length; ++i) {
            args[i] = this.convert(params[i], op.getSignature()[i].getType());
            sig[i] = op.getSignature()[i].getType();
        }
        return this.format(this.mserver.invoke(bean, op.getName(), args, sig), op.getReturnType());
    }

    private String format(Object v, String type) {
        if (type.equals("void")) {
            return null;
        }
        if (v instanceof CompositeData[]) {
            CompositeData[] td = (CompositeData[])v;
            if (td.length == 0) {
                return "";
            }
            ArrayList<String> header = new ArrayList<String>();
            for (String f : td[0].getCompositeType().keySet()) {
                if (header.contains(f)) continue;
                header.add(f);
            }
            ArrayList<String[]> content = new ArrayList<String[]>();
            content.add(header.toArray(new String[0]));
            for (CompositeData row : td) {
                content.add(this.formatRow(row, header));
            }
            return this.formatTable(content, this.widthThresholdTable, true);
        }
        if (v instanceof TabularData) {
            TabularData td = (TabularData)v;
            td.getTabularType().getIndexNames();
            ArrayList<String> header = new ArrayList<String>(td.getTabularType().getIndexNames());
            for (String f : td.getTabularType().getRowType().keySet()) {
                if (header.contains(f)) continue;
                header.add(f);
            }
            ArrayList<String[]> content = new ArrayList<String[]>();
            content.add(header.toArray(new String[0]));
            for (Object row : td.values()) {
                content.add(this.formatRow((CompositeData)row, header));
            }
            return this.formatTable(content, this.widthThresholdTable, true);
        }
        if (v instanceof CompositeData) {
            CompositeData cd = (CompositeData)v;
            ArrayList<String[]> content = new ArrayList<String[]>();
            for (String field : cd.getCompositeType().keySet()) {
                String val = this.formatLine(cd.get(field), cd.getCompositeType().getType(field).getClassName());
                content.add(new String[]{field + ": ", val});
            }
            return this.formatTable(content, this.widthThresholdComposite, false);
        }
        return this.formatLine(v, type);
    }

    private String formatTable(List<String[]> content, int maxCell, boolean table) {
        int[] width = new int[content.get(0).length];
        for (String[] row : content) {
            for (int i = 0; i != row.length; ++i) {
                width[i] = Math.min(Math.max(width[i], row[i].length()), maxCell);
            }
        }
        StringBuilder sb = new StringBuilder();
        boolean header = table;
        for (String[] row : content) {
            for (int i = 0; i != width.length; ++i) {
                String cell = row[i];
                if (cell.length() > width[i]) {
                    cell = cell.substring(0, width[i] - 3) + "...";
                }
                sb.append(cell);
                for (int s = 0; s != width[i] - cell.length(); ++s) {
                    sb.append(' ');
                }
                if (!table) continue;
                sb.append('|');
            }
            if (table) {
                sb.setLength(sb.length() - 1);
            }
            sb.append('\n');
            if (!header) continue;
            header = false;
            for (int n : width) {
                for (int i = 0; i != n; ++i) {
                    sb.append('-');
                }
                sb.append('+');
            }
            sb.setLength(sb.length() - 1);
            sb.append('\n');
        }
        return sb.toString();
    }

    private String formatLine(Object v, String type) {
        if (v instanceof TabularData) {
            TabularData td = (TabularData)v;
            StringBuilder sb = new StringBuilder();
            for (Object c : td.values()) {
                sb.append(this.formatLine(c, td.getTabularType().getRowType().getClassName()));
                sb.append(",");
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
            return sb.toString();
        }
        if (v instanceof CompositeData[]) {
            CompositeData[] td = (CompositeData[])v;
            StringBuilder sb = new StringBuilder();
            for (CompositeData c : td) {
                sb.append(this.formatLine(c, c.getCompositeType().getClassName()));
                sb.append(",");
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
            return sb.toString();
        }
        if (v instanceof CompositeData) {
            CompositeData cdata = (CompositeData)v;
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            for (String attr : cdata.getCompositeType().keySet()) {
                sb.append(attr).append("=");
                sb.append(this.formatLine(cdata.get(attr), cdata.getCompositeType().getType(attr).getClassName()));
                sb.append(',');
            }
            if (sb.length() > 1) {
                sb.setLength(sb.length() - 1);
            }
            sb.append("}");
            return sb.toString();
        }
        if (v instanceof Object[]) {
            return Arrays.toString((Object[])v);
        }
        if (v instanceof boolean[]) {
            return Arrays.toString((boolean[])v);
        }
        if (v instanceof byte[]) {
            return Arrays.toString((byte[])v);
        }
        if (v instanceof char[]) {
            return Arrays.toString((char[])v);
        }
        if (v instanceof short[]) {
            return Arrays.toString((short[])v);
        }
        if (v instanceof int[]) {
            return Arrays.toString((int[])v);
        }
        if (v instanceof long[]) {
            return Arrays.toString((long[])v);
        }
        if (v instanceof float[]) {
            return Arrays.toString((float[])v);
        }
        if (v instanceof double[]) {
            return Arrays.toString((double[])v);
        }
        return String.valueOf(v);
    }

    private String[] formatRow(CompositeData row, List<String> header) {
        String[] text = new String[header.size()];
        for (int i = 0; i != text.length; ++i) {
            String attr = header.get(i);
            text[i] = this.formatLine(row.get(attr), row.getCompositeType().getType(attr).getClassName());
        }
        return text;
    }

    private Object convert(String value, String type) {
        if (type.equals("java.lang.String")) {
            if ("<null>".equals(value.trim())) {
                return null;
            }
            return value;
        }
        if (type.equals("boolean") || type.equals("java.lang.Boolean")) {
            if (type.equals("java.lang.Boolean") && value.trim().isEmpty()) {
                return null;
            }
            return Boolean.valueOf(value);
        }
        if (type.equals("byte") || type.equals("java.lang.Byte")) {
            if (type.equals("java.lang.Byte") && value.trim().isEmpty()) {
                return null;
            }
            return Byte.valueOf(value);
        }
        if (type.equals("short") || type.equals("java.lang.Short")) {
            if (type.equals("java.lang.Short") && value.trim().isEmpty()) {
                return null;
            }
            return Short.valueOf(value);
        }
        if (type.equals("char") || type.equals("java.lang.Character")) {
            if (type.equals("java.lang.Character") && value.trim().isEmpty()) {
                return null;
            }
            if (value.length() == 1) {
                return Character.valueOf(value.charAt(0));
            }
            throw new IllegalArgumentException("Cannot convert '" + value + "' to " + type);
        }
        if (type.equals("int") || type.equals("java.lang.Integer")) {
            if (type.equals("java.lang.Integer") && value.trim().isEmpty()) {
                return null;
            }
            return Integer.valueOf(value);
        }
        if (type.equals("long") || type.equals("java.lang.Long")) {
            if (type.equals("java.lang.Long") && value.trim().isEmpty()) {
                return null;
            }
            return Long.valueOf(value);
        }
        if (type.equals("float") || type.equals("java.lang.Float")) {
            if (type.equals("java.lang.Float") && value.trim().isEmpty()) {
                return null;
            }
            return Float.valueOf(value);
        }
        if (type.equals("double") || type.equals("java.lang.Double")) {
            if (type.equals("java.lang.Double") && value.trim().isEmpty()) {
                return null;
            }
            return Double.valueOf(value);
        }
        if (type.startsWith("[")) {
            if (value.trim().isEmpty()) {
                return null;
            }
            String[] elements = value.split("[,]");
            Object array = ARRAY_MAP.get(type);
            if (array == null) {
                throw new IllegalArgumentException("Cannot convert '" + value + "' to " + type);
            }
            array = Array.newInstance(array.getClass().getComponentType(), elements.length);
            String etype = array.getClass().getComponentType().getName();
            for (int i = 0; i != elements.length; ++i) {
                Array.set(array, i, this.convert(elements[i], etype));
            }
            return array;
        }
        throw new IllegalArgumentException("Cannot convert '" + value + "' to " + type);
    }

    public String describe(ObjectName bean) throws Exception {
        MBeanInfo mbinfo = this.mserver.getMBeanInfo(bean);
        StringBuilder sb = new StringBuilder();
        sb.append(bean);
        sb.append('\n');
        sb.append(mbinfo.getClassName());
        sb.append('\n');
        sb.append(" - " + mbinfo.getDescription());
        sb.append('\n');
        for (MBeanAttributeInfo mBeanAttributeInfo : mbinfo.getAttributes()) {
            sb.append(" (A) ");
            sb.append(mBeanAttributeInfo.getName()).append(" : ").append(MBeanHelper.toPrintableType(mBeanAttributeInfo.getType())).append("");
            if (!mBeanAttributeInfo.isReadable()) {
                sb.append(" - WRITEONLY");
            } else if (mBeanAttributeInfo.isWritable()) {
                sb.append(" - WRITEABLE");
            }
            sb.append('\n');
            if (mBeanAttributeInfo.getName().equals(mBeanAttributeInfo.getDescription())) continue;
            sb.append("  - " + mBeanAttributeInfo.getDescription());
            sb.append('\n');
        }
        for (MBeanFeatureInfo mBeanFeatureInfo : mbinfo.getOperations()) {
            sb.append(" (O) ");
            sb.append(mBeanFeatureInfo.getName()).append("(");
            for (MBeanParameterInfo pi : ((MBeanOperationInfo)mBeanFeatureInfo).getSignature()) {
                String name = pi.getName();
                String type = MBeanHelper.toPrintableType(pi.getType());
                sb.append(type).append(' ').append(name).append(", ");
            }
            if (((MBeanOperationInfo)mBeanFeatureInfo).getSignature().length > 0) {
                sb.setLength(sb.length() - 2);
            }
            sb.append(") : ").append(MBeanHelper.toPrintableType(((MBeanOperationInfo)mBeanFeatureInfo).getReturnType()));
            sb.append('\n');
            if (mBeanFeatureInfo.getName().equals(mBeanFeatureInfo.getDescription())) continue;
            sb.append("  - " + mBeanFeatureInfo.getDescription());
            sb.append('\n');
        }
        return sb.toString();
    }

    static String toPrintableType(String type) {
        if (TYPE_MAP.containsKey(type)) {
            return TYPE_MAP.get(type);
        }
        if (type.startsWith("[L")) {
            return MBeanHelper.toPrintableType(type.substring(2, type.length() - 1)) + "[]";
        }
        return type;
    }

    static {
        ARRAY_MAP.put("[Z", new boolean[0]);
        ARRAY_MAP.put("[B", new byte[0]);
        ARRAY_MAP.put("[S", new short[0]);
        ARRAY_MAP.put("[C", new char[0]);
        ARRAY_MAP.put("[I", new int[0]);
        ARRAY_MAP.put("[J", new long[0]);
        ARRAY_MAP.put("[F", new float[0]);
        ARRAY_MAP.put("[D", new double[0]);
        ARRAY_MAP.put("[Ljava.lang.String;", new String[0]);
        TYPE_MAP = new HashMap<String, String>();
        TYPE_MAP.put("java.lang.String", "String");
        TYPE_MAP.put("javax.management.openmbean.CompositeData", "CompositeData");
        TYPE_MAP.put("javax.management.openmbean.TabularData", "TabularData");
        TYPE_MAP.put("[Z", "boolean[]");
        TYPE_MAP.put("[B", "byte[]");
        TYPE_MAP.put("[S", "short[]");
        TYPE_MAP.put("[C", "char[]");
        TYPE_MAP.put("[I", "int[]");
        TYPE_MAP.put("[J", "long[]");
        TYPE_MAP.put("[F", "float[]");
        TYPE_MAP.put("[D", "double[]");
    }
}

