/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.util;

import io.grpc.netty.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import java.util.AbstractQueue;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ExecutorUtil {
    private static Map<String, ThreadPoolExecutor> pools = new ConcurrentHashMap<String, ThreadPoolExecutor>();

    public static ThreadPoolExecutor getThreadPoolExecutor(String name) {
        if (name == null) {
            return null;
        }
        return pools.get(name);
    }

    public static ThreadPoolExecutor createExecutor(String name, int coreThreads, int maxThreads, int queueSize) {
        return ExecutorUtil.createExecutor(name, coreThreads, maxThreads, queueSize, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadPoolExecutor createExecutor(String name, int coreThreads, int maxThreads, int queueSize, boolean daemon) {
        ThreadPoolExecutor res = pools.get(name);
        if (res != null) {
            return res;
        }
        Map<String, ThreadPoolExecutor> map = pools;
        synchronized (map) {
            res = pools.get(name);
            if (res != null) {
                return res;
            }
            AbstractQueue queue = queueSize <= 0 ? new SynchronousQueue() : new LinkedBlockingQueue(queueSize);
            res = new ThreadPoolExecutor(coreThreads, maxThreads, 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)((Object)queue), (ThreadFactory)new DefaultThreadFactory(name, daemon));
            pools.put(name, res);
        }
        return res;
    }
}

