/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.struct.schema;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hugegraph.HugeGraphSupplier;
import org.apache.hugegraph.id.Id;
import org.apache.hugegraph.id.IdGenerator;
import org.apache.hugegraph.struct.schema.EdgeLabel;
import org.apache.hugegraph.struct.schema.PropertyKey;
import org.apache.hugegraph.struct.schema.SchemaElement;
import org.apache.hugegraph.struct.schema.SchemaLabel;
import org.apache.hugegraph.struct.schema.Userdata;
import org.apache.hugegraph.struct.schema.VertexLabel;
import org.apache.hugegraph.struct.schema.builder.SchemaBuilder;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.IndexType;
import org.apache.hugegraph.type.define.SchemaStatus;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.GraphUtils;

public class IndexLabel
extends SchemaElement {
    private HugeType baseType = HugeType.SYS_SCHEMA;
    private Id baseValue = NONE_ID;
    private IndexType indexType = IndexType.SECONDARY;
    private final List<Id> indexFields = new ArrayList<Id>();
    private static final IndexLabel VL_IL = new IndexLabel(-1L, "~vli");
    private static final IndexLabel EL_IL = new IndexLabel(-2L, "~eli");
    private static final IndexLabel PKN_IL = new IndexLabel(-3L, "~pkni");
    private static final IndexLabel VLN_IL = new IndexLabel(-4L, "~vlni");
    private static final IndexLabel ELN_IL = new IndexLabel(-5L, "~elni");
    private static final IndexLabel ILN_IL = new IndexLabel(-6L, "~ilni");

    public IndexLabel(HugeGraphSupplier graph, Id id, String name) {
        super(graph, id, name);
    }

    protected IndexLabel(long id, String name) {
        this(null, IdGenerator.of(id), name);
    }

    @Override
    public HugeType type() {
        return HugeType.INDEX_LABEL;
    }

    public HugeType baseType() {
        return this.baseType;
    }

    public void baseType(HugeType baseType) {
        this.baseType = baseType;
    }

    public Id baseValue() {
        return this.baseValue;
    }

    public void baseValue(Id id) {
        this.baseValue = id;
    }

    public IndexType indexType() {
        return this.indexType;
    }

    public void indexType(IndexType indexType) {
        this.indexType = indexType;
    }

    public HugeType queryType() {
        switch (this.baseType) {
            case VERTEX_LABEL: {
                return HugeType.VERTEX;
            }
            case EDGE_LABEL: {
                return HugeType.EDGE;
            }
            case SYS_SCHEMA: {
                return HugeType.SYS_SCHEMA;
            }
        }
        throw new AssertionError((Object)String.format("Query type of index label is either '%s' or '%s', but '%s' is used", HugeType.VERTEX_LABEL, HugeType.EDGE_LABEL, this.baseType));
    }

    public List<Id> indexFields() {
        return Collections.unmodifiableList(this.indexFields);
    }

    public void indexFields(Id ... ids) {
        this.indexFields.addAll(Arrays.asList(ids));
    }

    public void indexField(Id id) {
        this.indexFields.add(id);
    }

    public Id indexField() {
        E.checkState((this.indexFields.size() == 1 ? 1 : 0) != 0, (String)"There should be only one field in %s index label, but got: %s", (Object[])new Object[]{this.indexType.string(), this.indexFields});
        return this.indexFields.get(0);
    }

    public SchemaLabel baseLabel() {
        return IndexLabel.getBaseLabel(this.graph, this.baseType, this.baseValue);
    }

    public SchemaLabel baseElement() {
        return IndexLabel.getElement(this.graph, this.baseType, this.baseValue);
    }

    public boolean hasSameContent(IndexLabel other) {
        return super.hasSameContent(other) && this.indexType == other.indexType && this.baseType == other.baseType && Objects.equal(this.graph.mapPkId2Name(this.indexFields), other.graph.mapPkId2Name(other.indexFields));
    }

    public boolean olap() {
        return VertexLabel.OLAP_VL.id().equals(this.baseValue);
    }

    public Object validValue(Object value) {
        if (!(value instanceof Number)) {
            return value;
        }
        Number number = (Number)value;
        switch (this.indexType()) {
            case RANGE_INT: {
                return number.intValue();
            }
            case RANGE_LONG: {
                return number.longValue();
            }
            case RANGE_FLOAT: {
                return Float.valueOf(number.floatValue());
            }
            case RANGE_DOUBLE: {
                return number.doubleValue();
            }
        }
        return value;
    }

    public static IndexLabel label(HugeType type) {
        switch (type) {
            case TASK: 
            case SERVER: 
            case VERTEX: {
                return VL_IL;
            }
            case EDGE: 
            case EDGE_OUT: 
            case EDGE_IN: {
                return EL_IL;
            }
            case PROPERTY_KEY: {
                return PKN_IL;
            }
            case VERTEX_LABEL: {
                return VLN_IL;
            }
            case EDGE_LABEL: {
                return ELN_IL;
            }
            case INDEX_LABEL: {
                return ILN_IL;
            }
        }
        throw new AssertionError((Object)String.format("No primitive index label for '%s'", type));
    }

    public static IndexLabel label(HugeGraphSupplier graph, Id id) {
        if (id.asLong() < 0L && id.asLong() > -8L) {
            switch ((int)id.asLong()) {
                case -1: {
                    return VL_IL;
                }
                case -2: {
                    return EL_IL;
                }
                case -3: {
                    return PKN_IL;
                }
                case -4: {
                    return VLN_IL;
                }
                case -5: {
                    return ELN_IL;
                }
                case -6: {
                    return ILN_IL;
                }
            }
            throw new AssertionError((Object)String.format("No primitive index label for '%s'", id));
        }
        return graph.indexLabel(id);
    }

    public static SchemaLabel getBaseLabel(HugeGraphSupplier graph, HugeType baseType, Object baseValue) {
        SchemaLabel label;
        E.checkNotNull((Object)baseType, (String)"base type", (String)"index label");
        E.checkNotNull((Object)baseValue, (String)"base value", (String)"index label");
        E.checkArgument((baseValue instanceof String || baseValue instanceof Id ? 1 : 0) != 0, (String)"The base value must be instance of String or Id, but got %s(%s)", (Object[])new Object[]{baseValue, baseValue.getClass().getSimpleName()});
        switch (baseType) {
            case VERTEX_LABEL: {
                if (baseValue instanceof String) {
                    label = graph.vertexLabel((String)baseValue);
                    break;
                }
                assert (baseValue instanceof Id);
                label = graph.vertexLabel((Id)baseValue);
                break;
            }
            case EDGE_LABEL: {
                if (baseValue instanceof String) {
                    label = graph.edgeLabel((String)baseValue);
                    break;
                }
                assert (baseValue instanceof Id);
                label = graph.edgeLabel((Id)baseValue);
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Unsupported base type '%s' of index label", baseType));
            }
        }
        E.checkArgumentNotNull((Object)label, (String)"Can't find the %s with name '%s'", (Object[])new Object[]{baseType.readableName(), baseValue});
        return label;
    }

    public static SchemaLabel getElement(HugeGraphSupplier graph, HugeType baseType, Object baseValue) {
        SchemaLabel label;
        E.checkNotNull((Object)baseType, (String)"base type", (String)"index label");
        E.checkNotNull((Object)baseValue, (String)"base value", (String)"index label");
        E.checkArgument((baseValue instanceof String || baseValue instanceof Id ? 1 : 0) != 0, (String)"The base value must be instance of String or Id, but got %s(%s)", (Object[])new Object[]{baseValue, baseValue.getClass().getSimpleName()});
        switch (baseType) {
            case VERTEX_LABEL: {
                if (baseValue instanceof String) {
                    label = graph.vertexLabel((String)baseValue);
                    break;
                }
                assert (baseValue instanceof Id);
                label = graph.vertexLabel((Id)baseValue);
                break;
            }
            case EDGE_LABEL: {
                if (baseValue instanceof String) {
                    label = graph.edgeLabel((String)baseValue);
                    break;
                }
                assert (baseValue instanceof Id);
                label = graph.edgeLabel((Id)baseValue);
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Unsupported base type '%s' of index label", baseType));
            }
        }
        E.checkArgumentNotNull((Object)label, (String)"Can't find the %s with name '%s'", (Object[])new Object[]{baseType.readableName(), baseValue});
        return label;
    }

    public String convert2Groovy(boolean attachIdFlag) {
        StringBuilder builder = new StringBuilder("graph.schema().");
        if (!attachIdFlag) {
            builder.append("indexLabel").append("('").append(this.name()).append("')");
        } else {
            builder.append("indexLabel").append("(").append(this.longId()).append(", '").append(this.name()).append("')");
        }
        switch (this.baseType()) {
            case VERTEX_LABEL: {
                VertexLabel vl = this.graph.vertexLabel(this.baseValue);
                builder.append(".onV('").append(vl.name()).append("')");
                break;
            }
            case EDGE_LABEL: {
                EdgeLabel el = this.graph.edgeLabel(this.baseValue);
                builder.append(".onE('").append(el.name()).append("')");
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Invalid base type '%s'", this.baseType()));
            }
        }
        builder.append(".by(");
        List<Id> properties = this.indexFields();
        int size = properties.size();
        for (Id id : properties) {
            PropertyKey pk = this.graph.propertyKey(id);
            builder.append("'").append(pk.name()).append("'");
            if (--size <= 0) continue;
            builder.append(",");
        }
        builder.append(")");
        builder.append(".");
        switch (this.indexType()) {
            case SECONDARY: {
                builder.append("secondary()");
                break;
            }
            case RANGE_INT: 
            case RANGE_LONG: 
            case RANGE_FLOAT: 
            case RANGE_DOUBLE: {
                builder.append("range()");
                break;
            }
            case SEARCH: {
                builder.append("search()");
                break;
            }
            case SHARD: {
                builder.append("shard()");
                break;
            }
            case UNIQUE: {
                builder.append("unique()");
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Invalid index type '%s'", this.indexType()));
            }
        }
        Map<String, Object> userdata = this.userdata();
        if (userdata.isEmpty()) {
            return builder.toString();
        }
        for (Map.Entry<String, Object> entry : userdata.entrySet()) {
            if (GraphUtils.isHidden(entry.getKey())) continue;
            builder.append(".userdata('").append(entry.getKey()).append("',").append(entry.getValue()).append(")");
        }
        builder.append(".ifNotExist().create();");
        return builder.toString();
    }

    @Override
    public Map<String, Object> asMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("baseType", this.baseType().name());
        map.put("baseValue", this.baseValue().asString());
        map.put("indexType", this.indexType().name());
        map.put("indexFields", this.indexFields());
        return super.asMap(map);
    }

    public static IndexLabel fromMap(Map<String, Object> map, HugeGraphSupplier graph) {
        Id id = IdGenerator.of(((Integer)map.get("id")).intValue());
        String name = (String)map.get("name");
        IndexLabel indexLabel = new IndexLabel(graph, id, name);
        block19: for (Map.Entry<String, Object> entry : map.entrySet()) {
            switch (entry.getKey()) {
                case "id": 
                case "name": {
                    continue block19;
                }
                case "status": {
                    indexLabel.status(SchemaStatus.valueOf(((String)entry.getValue()).toUpperCase()));
                    continue block19;
                }
                case "userdata": {
                    indexLabel.userdata(new Userdata((Map)entry.getValue()));
                    continue block19;
                }
                case "baseType": {
                    HugeType hugeType = HugeType.valueOf(((String)entry.getValue()).toUpperCase());
                    indexLabel.baseType(hugeType);
                    continue block19;
                }
                case "baseValue": {
                    long sourceLabel = Long.parseLong((String)entry.getValue());
                    indexLabel.baseValue(IdGenerator.of(sourceLabel));
                    continue block19;
                }
                case "indexType": {
                    IndexType indexType = IndexType.valueOf(((String)entry.getValue()).toUpperCase());
                    indexLabel.indexType(indexType);
                    continue block19;
                }
                case "indexFields": {
                    List<Id> ids = ((List)entry.getValue()).stream().map(IdGenerator::of).collect(Collectors.toList());
                    indexLabel.indexFields(ids.toArray(new Id[0]));
                    continue block19;
                }
            }
            throw new AssertionError((Object)String.format("Invalid key '%s' for index label", entry.getKey()));
        }
        return indexLabel;
    }

    public static final class P {
        public static final String ID = "id";
        public static final String NAME = "name";
        public static final String STATUS = "status";
        public static final String USERDATA = "userdata";
        public static final String BASE_TYPE = "baseType";
        public static final String BASE_VALUE = "baseValue";
        public static final String INDEX_TYPE = "indexType";
        public static final String INDEX_FIELDS = "indexFields";
    }

    public static interface Builder
    extends SchemaBuilder<IndexLabel> {
        public SchemaElement.TaskWithSchema createWithTask();

        public Id rebuild();

        public Builder onV(String var1);

        public Builder onE(String var1);

        public Builder by(String ... var1);

        public Builder secondary();

        public Builder range();

        public Builder search();

        public Builder shard();

        public Builder unique();

        public Builder on(HugeType var1, String var2);

        public Builder indexType(IndexType var1);

        public Builder userdata(String var1, Object var2);

        public Builder userdata(Map<String, Object> var1);

        public Builder rebuild(boolean var1);
    }
}

