/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.hugegraph.concurrent.PausableScheduledThreadPool;

public final class ExecutorUtil {
    public static ThreadPoolExecutor newDynamicThreadExecutor(String name, int corePoolSize, int maximumPoolSize) {
        long keepAliveTime = 60L;
        TimeUnit unit = TimeUnit.SECONDS;
        BasicThreadFactory factory = new BasicThreadFactory.Builder().namingPattern(name).build();
        CustomBlockingQueue<Runnable> workQueue = new CustomBlockingQueue<Runnable>();
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, (ThreadFactory)factory, new ThreadPoolExecutor.CallerRunsPolicy());
        workQueue.setThreadPoolExecutor(threadPoolExecutor);
        return threadPoolExecutor;
    }

    public static ExecutorService newFixedThreadPool(String name) {
        return ExecutorUtil.newFixedThreadPool(1, name);
    }

    public static ExecutorService newFixedThreadPool(int size, String name) {
        BasicThreadFactory factory = new BasicThreadFactory.Builder().namingPattern(name).build();
        return Executors.newFixedThreadPool(size, (ThreadFactory)factory);
    }

    public static ScheduledExecutorService newScheduledThreadPool(String name) {
        return ExecutorUtil.newScheduledThreadPool(1, name);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int size, String name) {
        BasicThreadFactory factory = new BasicThreadFactory.Builder().namingPattern(name).build();
        return Executors.newScheduledThreadPool(size, (ThreadFactory)factory);
    }

    public static PausableScheduledThreadPool newPausableScheduledThreadPool(String name) {
        return ExecutorUtil.newPausableScheduledThreadPool(1, name);
    }

    public static PausableScheduledThreadPool newPausableScheduledThreadPool(int size, String name) {
        BasicThreadFactory factory = new BasicThreadFactory.Builder().namingPattern(name).build();
        return new PausableScheduledThreadPool(size, (ThreadFactory)factory);
    }

    static class CustomBlockingQueue<E>
    extends LinkedBlockingQueue<E> {
        private ThreadPoolExecutor threadPoolExecutor;

        CustomBlockingQueue() {
        }

        public void setThreadPoolExecutor(ThreadPoolExecutor threadPoolExecutor) {
            this.threadPoolExecutor = threadPoolExecutor;
        }

        @Override
        public boolean offer(E e) {
            if (this.threadPoolExecutor.getPoolSize() < this.threadPoolExecutor.getMaximumPoolSize()) {
                return false;
            }
            return super.offer(e);
        }
    }
}

