/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.buffer;

import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ByteBufferAllocator {
    final int capacity;
    final int maxCount;
    final BlockingQueue<ByteBuffer> freeQueue = new LinkedBlockingQueue<ByteBuffer>();
    AtomicInteger totalCount;

    public ByteBufferAllocator(int cap, int count) {
        this.capacity = cap;
        this.maxCount = count;
        this.totalCount = new AtomicInteger(0);
    }

    public ByteBuffer get() throws InterruptedException {
        ByteBuffer buffer = null;
        while (buffer == null) {
            if (this.freeQueue.size() > 0) {
                buffer = (ByteBuffer)this.freeQueue.poll();
                continue;
            }
            if (this.totalCount.get() < this.maxCount) {
                buffer = ByteBuffer.allocate(this.capacity);
                this.totalCount.incrementAndGet();
                continue;
            }
            buffer = this.freeQueue.poll(1L, TimeUnit.SECONDS);
        }
        return buffer;
    }

    public void release(ByteBuffer buffer) {
        if (this.freeQueue.size() < this.maxCount) {
            buffer.clear();
            this.freeQueue.add(buffer);
        }
    }
}

