/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.upgrade.scripts;

import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.config.PDConfig;
import org.apache.hugegraph.pd.meta.MetadataKeyHelper;
import org.apache.hugegraph.pd.meta.MetadataRocksDBStore;
import org.apache.hugegraph.pd.upgrade.VersionUpgradeScript;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCleanUpgrade
implements VersionUpgradeScript {
    private static final Logger log = LoggerFactory.getLogger(TaskCleanUpgrade.class);

    public String getHighVersion() {
        return "UNLIMITED_VERSION";
    }

    public String getLowVersion() {
        return "UNLIMITED_VERSION";
    }

    public boolean isRunWithoutDataVersion() {
        return true;
    }

    public boolean isRunOnce() {
        return true;
    }

    public void runInstruction(PDConfig config) {
        log.info("run TaskCleanUpgrade script");
        MetadataRocksDBStore dbStore = new MetadataRocksDBStore(config);
        try {
            byte[] key = MetadataKeyHelper.getAllSplitTaskPrefix();
            log.info("delete split task:{}", (Object)dbStore.removeByPrefix(key));
            byte[] key2 = MetadataKeyHelper.getAllMoveTaskPrefix();
            log.info("delete move task:{}", (Object)dbStore.removeByPrefix(key2));
        }
        catch (PDException e) {
            throw new RuntimeException(e);
        }
    }
}

