/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.service;

import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.MethodDescriptor;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.grpc.Pdpb;
import org.apache.hugegraph.pd.raft.RaftEngine;
import org.apache.hugegraph.pd.raft.RaftStateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ServiceGrpc
extends RaftStateListener {
    public static final ConcurrentHashMap<String, ManagedChannel> channels = new ConcurrentHashMap();
    public static final ManagedChannel channel = null;
    public static final Logger log = LoggerFactory.getLogger(ServiceGrpc.class);
    public static final int deadline = 60;

    default public Pdpb.ResponseHeader getResponseHeader(PDException e) {
        Pdpb.Error error = Pdpb.Error.newBuilder().setTypeValue(e.getErrorCode()).setMessage(e.getMessage()).build();
        Pdpb.ResponseHeader header = Pdpb.ResponseHeader.newBuilder().setError(error).build();
        return header;
    }

    default public Pdpb.ResponseHeader getResponseHeader() {
        Pdpb.Error error = Pdpb.Error.newBuilder().setType(Pdpb.ErrorType.OK).build();
        Pdpb.ResponseHeader header = Pdpb.ResponseHeader.newBuilder().setError(error).build();
        return header;
    }

    default public boolean isLeader() {
        return RaftEngine.getInstance().isLeader();
    }

    default public <ReqT, RespT> void redirectToLeader(ManagedChannel channel, MethodDescriptor<ReqT, RespT> method, ReqT req, StreamObserver<RespT> observer) {
        try {
            String address = RaftEngine.getInstance().getLeaderGrpcAddress();
            channel = channels.compute(address, (addr, existingChannel) -> {
                if (existingChannel != null && !existingChannel.isTerminated() && !existingChannel.isShutdown()) {
                    return existingChannel;
                }
                try {
                    while (existingChannel != null && existingChannel.isShutdown() && !existingChannel.isTerminated()) {
                        existingChannel.awaitTermination(50L, TimeUnit.MILLISECONDS);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.warn("Interrupted while waiting for channel termination", (Throwable)e);
                }
                return ManagedChannelBuilder.forTarget((String)addr).maxInboundMessageSize(Integer.MAX_VALUE).usePlaintext().build();
            });
            CallOptions callOptions = CallOptions.DEFAULT.withDeadlineAfter(60L, TimeUnit.SECONDS);
            ClientCalls.asyncUnaryCall((ClientCall)channel.newCall(method, callOptions), req, observer);
        }
        catch (Exception e) {
            log.warn("redirect to leader with error:", (Throwable)e);
        }
    }

    default public <ReqT, RespT> void redirectToLeader(MethodDescriptor<ReqT, RespT> method, ReqT req, StreamObserver<RespT> observer) {
        this.redirectToLeader(channel, method, req, observer);
    }

    default public void onRaftLeaderChanged() {
    }
}

