/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client.util;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.CheckForNull;
import org.apache.hugegraph.store.client.type.HgStoreClientException;
import org.apache.hugegraph.store.client.util.HgAssert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HgBufferProxy<T> {
    private static final Logger log = LoggerFactory.getLogger(HgBufferProxy.class);
    private final BlockingQueue<Supplier<T>> queue;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ReentrantLock lock = new ReentrantLock();
    private final Runnable task;
    private Throwable err;

    private HgBufferProxy(Runnable task) {
        this.task = task;
        this.queue = new LinkedBlockingQueue<Supplier<T>>();
    }

    public static HgBufferProxy of(Runnable task) {
        HgAssert.isArgumentNotNull(task, "task");
        return new HgBufferProxy(task);
    }

    public void send(T t) {
        if (t == null) {
            throw new IllegalArgumentException("the argument t is null");
        }
        if (this.closed.get()) {
            return;
        }
        this.lock.lock();
        try {
            this.queue.offer(() -> t);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void apply() {
        this.lock.lock();
        try {
            if (!this.closed.get()) {
                this.task.run();
                Thread.yield();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public T receive(int time, Consumer<Integer> callback) {
        Supplier s;
        if (this.closed.get()) {
            Supplier s2 = (Supplier)this.queue.poll();
            this.checkErr();
            return s2 != null ? (T)s2.get() : null;
        }
        if (this.queue.size() <= 1) {
            this.apply();
        }
        this.lock.lock();
        try {
            if (this.isClosed()) {
                Supplier s3 = (Supplier)this.queue.poll();
                this.checkErr();
                T t = s3 != null ? (T)s3.get() : null;
                return t;
            }
        }
        finally {
            this.lock.unlock();
        }
        try {
            s = this.queue.poll(time, TimeUnit.SECONDS);
        }
        catch (Throwable t) {
            log.error("failed to receive a item from channel, cause by: ", t);
            throw HgStoreClientException.of(t);
        }
        if (s == null) {
            if (this.closed.get()) {
                s = (Supplier)this.queue.poll();
            } else {
                if (callback == null) {
                    throw new RuntimeException("timeout, max time: " + time + " seconds");
                }
                callback.accept(time);
            }
        }
        this.checkErr();
        return s != null ? (T)s.get() : null;
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public void close() {
        if (this.closed.get()) {
            return;
        }
        this.lock.lock();
        this.closed.set(true);
        try {
            this.queue.offer(() -> null);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setError(Throwable streamErr) {
        this.err = streamErr;
    }

    private void checkErr() {
        if (this.err != null) {
            throw HgStoreClientException.of(this.err);
        }
    }
}

