/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client.util;

import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hugegraph.store.client.util.HgAssert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecutorPool {
    private static final Logger log = LoggerFactory.getLogger(ExecutorPool.class);

    public static ThreadFactory newThreadFactory(String namePrefix) {
        HgAssert.isArgumentNotNull(namePrefix, "namePrefix");
        return new DefaultThreadFactory(namePrefix);
    }

    public static ThreadPoolExecutor createExecutor(String name, long keepAliveTime, int coreThreads, int maxThreads) {
        return new ThreadPoolExecutor(coreThreads, maxThreads, keepAliveTime, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), ExecutorPool.newThreadFactory(name), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public static class DefaultThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        public DefaultThreadFactory(String threadNamePrefix) {
            this.namePrefix = threadNamePrefix + "-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(null, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            t.setDaemon(true);
            t.setPriority(5);
            return t;
        }
    }
}

