/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client.query;

import io.grpc.stub.StreamObserver;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.hugegraph.store.client.query.ErrorMessageIterator;
import org.apache.hugegraph.store.client.query.ResultState;
import org.apache.hugegraph.store.client.type.HgStoreClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonKvStreamObserver<R, T>
implements StreamObserver<R> {
    private static final Logger log = LoggerFactory.getLogger(CommonKvStreamObserver.class);
    private final BlockingQueue<Iterator<T>> queue;
    private Consumer<Boolean> requestSender;
    private Consumer<Boolean> transferComplete;
    private final Function<R, Iterator<T>> valueExtractor;
    private final Function<R, ResultState> stateWatcher;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private long timeout = 1800000L;
    private final ResultStateWatcher watcher = new ResultStateWatcher();

    public CommonKvStreamObserver(Function<R, Iterator<T>> valueExtractor, Function<R, ResultState> stateWatcher) {
        this.queue = new LinkedBlockingQueue<Iterator<T>>();
        this.valueExtractor = valueExtractor;
        this.stateWatcher = stateWatcher;
    }

    public void sendRequest() {
        if (!this.isServerFinished() && !this.closed.get()) {
            this.requestSender.accept(true);
            this.watcher.setState(ResultState.WAITING);
        }
    }

    public boolean isServerFinished() {
        return this.watcher.getState() == ResultState.FINISHED || this.watcher.getState() == ResultState.ERROR;
    }

    public void onNext(R value) {
        this.watcher.setState(ResultState.INNER_BUSY);
        try {
            ResultState state = this.stateWatcher.apply(value);
            log.debug("observer state: {}", (Object)state);
            switch (state) {
                case IDLE: 
                case FINISHED: {
                    if (this.closed.get()) break;
                    this.queue.offer(this.valueExtractor.apply(value));
                    break;
                }
                default: {
                    this.queue.offer(new ErrorMessageIterator(state.getMessage()));
                }
            }
            this.watcher.setState(state);
        }
        catch (Exception e) {
            log.error("handling server data, got error: ", (Throwable)e);
            this.queue.offer(new ErrorMessageIterator(e.getMessage()));
        }
    }

    public Iterator<T> consume() {
        try {
            while (!(Thread.currentThread().isInterrupted() || this.queue.isEmpty() && this.isServerFinished())) {
                Iterator<T> iterator = this.queue.poll(200L, TimeUnit.MILLISECONDS);
                if (iterator != null) {
                    this.sendRequest();
                    return iterator;
                }
                if ((System.nanoTime() - this.watcher.current) / 1000000L <= this.timeout) continue;
                throw new HgStoreClientException("iterator timeout");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return null;
    }

    public void clear() {
        if (!this.closed.get()) {
            this.closed.set(true);
            this.transferComplete.accept(true);
        }
        this.queue.clear();
    }

    public void onError(Throwable t) {
        log.error("StreamObserver got error:", t);
        this.queue.offer(new ErrorMessageIterator(t.getMessage()));
        this.watcher.setState(ResultState.ERROR);
    }

    public void onCompleted() {
        if (this.watcher.getState() != ResultState.ERROR) {
            this.watcher.setState(ResultState.FINISHED);
        }
    }

    public void setWatcherQueryId(String queryId) {
        this.watcher.setQueryId(queryId);
    }

    public void setRequestSender(Consumer<Boolean> requestSender) {
        this.requestSender = requestSender;
    }

    public void setTransferComplete(Consumer<Boolean> transferComplete) {
        this.transferComplete = transferComplete;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    private static class ResultStateWatcher {
        private long current = System.nanoTime();
        private volatile ResultState state = ResultState.IDLE;
        private String queryId;

        public void setState(ResultState state) {
            log.debug("query Id: {}, COST_STAT: {} -> {}, cost {} ms", new Object[]{this.queryId, this.state, state, (double)(System.nanoTime() - this.current) * 1.0 / 1000000.0});
            this.state = state;
            this.current = System.nanoTime();
        }

        public long getCurrent() {
            return this.current;
        }

        public ResultState getState() {
            return this.state;
        }

        public String getQueryId() {
            return this.queryId;
        }

        public void setCurrent(long current) {
            this.current = current;
        }

        public void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultStateWatcher)) {
                return false;
            }
            ResultStateWatcher other = (ResultStateWatcher)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCurrent() != other.getCurrent()) {
                return false;
            }
            ResultState this$state = this.getState();
            ResultState other$state = other.getState();
            if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
                return false;
            }
            String this$queryId = this.getQueryId();
            String other$queryId = other.getQueryId();
            return !(this$queryId == null ? other$queryId != null : !this$queryId.equals(other$queryId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ResultStateWatcher;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $current = this.getCurrent();
            result = result * 59 + (int)($current >>> 32 ^ $current);
            ResultState $state = this.getState();
            result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
            String $queryId = this.getQueryId();
            result = result * 59 + ($queryId == null ? 43 : $queryId.hashCode());
            return result;
        }

        public String toString() {
            return "CommonKvStreamObserver.ResultStateWatcher(current=" + this.getCurrent() + ", state=" + String.valueOf((Object)this.getState()) + ", queryId=" + this.getQueryId() + ")";
        }
    }
}

