/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.io.ByteBufferWriter;
import org.apache.hadoop.hbase.io.util.StreamUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.UnsafeAccess;
import org.apache.hadoop.hbase.util.UnsafeAvailChecker;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import sun.nio.ch.DirectBuffer;

@InterfaceAudience.Public
public final class ByteBufferUtils {
    public static final int VALUE_MASK = 127;
    public static final int NEXT_BIT_SHIFT = 7;
    public static final int NEXT_BIT_MASK = 128;
    @VisibleForTesting
    static final boolean UNSAFE_AVAIL = UnsafeAvailChecker.isAvailable();
    public static final boolean UNSAFE_UNALIGNED = UnsafeAvailChecker.unaligned();

    private ByteBufferUtils() {
    }

    public static void writeVLong(ByteBuffer out, long i) {
        if (i >= -112L && i <= 127L) {
            out.put((byte)i);
            return;
        }
        int len = -112;
        if (i < 0L) {
            i ^= 0xFFFFFFFFFFFFFFFFL;
            len = -120;
        }
        long tmp = i;
        while (tmp != 0L) {
            tmp >>= 8;
            --len;
        }
        out.put((byte)len);
        for (int idx = len = len < -120 ? -(len + 120) : -(len + 112); idx != 0; --idx) {
            int shiftbits = (idx - 1) * 8;
            long mask = 255L << shiftbits;
            out.put((byte)((i & mask) >> shiftbits));
        }
    }

    public static long readVLong(ByteBuffer in) {
        byte firstByte = in.get();
        int len = WritableUtils.decodeVIntSize(firstByte);
        if (len == 1) {
            return firstByte;
        }
        long i = 0L;
        for (int idx = 0; idx < len - 1; ++idx) {
            byte b = in.get();
            i <<= 8;
            i |= (long)(b & 0xFF);
        }
        return WritableUtils.isNegativeVInt(firstByte) ? i ^ 0xFFFFFFFFFFFFFFFFL : i;
    }

    public static int putCompressedInt(OutputStream out, int value) throws IOException {
        int i = 0;
        int tmpvalue = value;
        do {
            byte b = (byte)(tmpvalue & 0x7F);
            if ((tmpvalue >>>= 7) != 0) {
                b = (byte)(b | 0xFFFFFF80);
            }
            out.write(b);
            ++i;
        } while (tmpvalue != 0);
        return i;
    }

    public static void putInt(OutputStream out, int value) throws IOException {
        if (out instanceof ByteBufferWriter) {
            ((ByteBufferWriter)((Object)out)).writeInt(value);
        } else {
            StreamUtils.writeInt(out, value);
        }
    }

    public static byte toByte(ByteBuffer buffer, int offset) {
        if (UNSAFE_AVAIL) {
            return UnsafeAccess.toByte(buffer, offset);
        }
        return buffer.get(offset);
    }

    public static void moveBufferToStream(OutputStream out, ByteBuffer in, int length) throws IOException {
        ByteBufferUtils.copyBufferToStream(out, in, in.position(), length);
        ByteBufferUtils.skip(in, length);
    }

    public static void copyBufferToStream(OutputStream out, ByteBuffer in, int offset, int length) throws IOException {
        if (out instanceof ByteBufferWriter) {
            ((ByteBufferWriter)((Object)out)).write(in, offset, length);
        } else if (in.hasArray()) {
            out.write(in.array(), in.arrayOffset() + offset, length);
        } else {
            for (int i = 0; i < length; ++i) {
                out.write(ByteBufferUtils.toByte(in, offset + i));
            }
        }
    }

    public static void copyBufferToStream(DataOutput out, ByteBuffer in, int offset, int length) throws IOException {
        if (out instanceof ByteBufferWriter) {
            ((ByteBufferWriter)((Object)out)).write(in, offset, length);
        } else if (in.hasArray()) {
            out.write(in.array(), in.arrayOffset() + offset, length);
        } else {
            for (int i = 0; i < length; ++i) {
                out.write(ByteBufferUtils.toByte(in, offset + i));
            }
        }
    }

    public static int putLong(OutputStream out, long value, int fitInBytes) throws IOException {
        long tmpValue = value;
        for (int i = 0; i < fitInBytes; ++i) {
            out.write((byte)(tmpValue & 0xFFL));
            tmpValue >>>= 8;
        }
        return fitInBytes;
    }

    public static int putByte(ByteBuffer buffer, int offset, byte b) {
        if (UNSAFE_AVAIL) {
            return UnsafeAccess.putByte(buffer, offset, b);
        }
        buffer.put(offset, b);
        return offset + 1;
    }

    public static int longFitsIn(long value) {
        if (value < 0L) {
            return 8;
        }
        if (value < 0x100000000L) {
            if (value < 65536L) {
                if (value < 256L) {
                    return 1;
                }
                return 2;
            }
            if (value < 0x1000000L) {
                return 3;
            }
            return 4;
        }
        if (value < 0x1000000000000L) {
            if (value < 0x10000000000L) {
                return 5;
            }
            return 6;
        }
        if (value < 0x100000000000000L) {
            return 7;
        }
        return 8;
    }

    public static int intFitsIn(int value) {
        if (value < 0) {
            return 4;
        }
        if (value < 65536) {
            if (value < 256) {
                return 1;
            }
            return 2;
        }
        if (value <= 0x1000000) {
            return 3;
        }
        return 4;
    }

    public static int readCompressedInt(InputStream input) throws IOException {
        byte b;
        int result = 0;
        int i = 0;
        do {
            b = (byte)input.read();
            result += (b & 0x7F) << 7 * i;
            if (++i <= 5) continue;
            throw new IllegalStateException("Corrupted compressed int (too long: " + (i + 1) + " bytes)");
        } while (0 != (b & 0x80));
        return result;
    }

    public static int readCompressedInt(ByteBuffer buffer) {
        byte b = buffer.get();
        if ((b & 0x80) != 0) {
            return (b & 0x7F) + (ByteBufferUtils.readCompressedInt(buffer) << 7);
        }
        return b & 0x7F;
    }

    public static long readLong(InputStream in, int fitInBytes) throws IOException {
        long tmpLong = 0L;
        for (int i = 0; i < fitInBytes; ++i) {
            tmpLong |= ((long)in.read() & 0xFFL) << 8 * i;
        }
        return tmpLong;
    }

    public static long readLong(ByteBuffer in, int fitInBytes) {
        long tmpLength = 0L;
        for (int i = 0; i < fitInBytes; ++i) {
            tmpLength |= ((long)in.get() & 0xFFL) << (int)(8L * (long)i);
        }
        return tmpLength;
    }

    public static void copyFromStreamToBuffer(ByteBuffer out, DataInputStream in, int length) throws IOException {
        if (out.hasArray()) {
            in.readFully(out.array(), out.position() + out.arrayOffset(), length);
            ByteBufferUtils.skip(out, length);
        } else {
            for (int i = 0; i < length; ++i) {
                out.put(in.readByte());
            }
        }
    }

    public static ByteBuffer drainInputStreamToBuffer(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        IOUtils.copyBytes(is, (OutputStream)baos, 4096, true);
        ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
        buffer.rewind();
        return buffer;
    }

    public static void copyFromBufferToBuffer(ByteBuffer in, ByteBuffer out) {
        if (in.hasArray() && out.hasArray()) {
            int length = in.remaining();
            System.arraycopy(in.array(), in.arrayOffset(), out.array(), out.arrayOffset(), length);
            out.position(out.position() + length);
            in.position(in.limit());
        } else if (UNSAFE_AVAIL) {
            int length = in.remaining();
            UnsafeAccess.copy(in, in.position(), out, out.position(), length);
            out.position(out.position() + length);
            in.position(in.limit());
        } else {
            out.put(in);
        }
    }

    public static void copyFromBufferToBuffer(ByteBuffer in, ByteBuffer out, int sourceOffset, int destinationOffset, int length) {
        if (in.hasArray() && out.hasArray()) {
            System.arraycopy(in.array(), sourceOffset + in.arrayOffset(), out.array(), out.arrayOffset() + destinationOffset, length);
        } else if (UNSAFE_AVAIL) {
            UnsafeAccess.copy(in, sourceOffset, out, destinationOffset, length);
        } else {
            ByteBuffer outDup = out.duplicate();
            outDup.position(destinationOffset);
            ByteBuffer inDup = in.duplicate();
            inDup.position(sourceOffset).limit(sourceOffset + length);
            outDup.put(inDup);
        }
    }

    public static void copyFromBufferToBuffer(ByteBuffer in, ByteBuffer out, int sourceOffset, int length) {
        if (in.hasArray() && out.hasArray()) {
            System.arraycopy(in.array(), sourceOffset + in.arrayOffset(), out.array(), out.position() + out.arrayOffset(), length);
            ByteBufferUtils.skip(out, length);
        } else if (UNSAFE_AVAIL) {
            UnsafeAccess.copy(in, sourceOffset, out, out.position(), length);
            ByteBufferUtils.skip(out, length);
        } else {
            ByteBuffer inDup = in.duplicate();
            inDup.position(sourceOffset).limit(sourceOffset + length);
            out.put(inDup);
        }
    }

    public static int findCommonPrefix(ByteBuffer buffer, int offsetLeft, int offsetRight, int limit) {
        int prefix;
        for (prefix = 0; prefix < limit && buffer.get(offsetLeft + prefix) == buffer.get(offsetRight + prefix); ++prefix) {
        }
        return prefix;
    }

    public static int findCommonPrefix(byte[] left, int leftOffset, int leftLength, byte[] right, int rightOffset, int rightLength) {
        int result;
        int length = Math.min(leftLength, rightLength);
        for (result = 0; result < length && left[leftOffset + result] == right[rightOffset + result]; ++result) {
        }
        return result;
    }

    public static int findCommonPrefix(ByteBuffer left, int leftOffset, int leftLength, ByteBuffer right, int rightOffset, int rightLength) {
        int result;
        int length = Math.min(leftLength, rightLength);
        for (result = 0; result < length && ByteBufferUtils.toByte(left, leftOffset + result) == ByteBufferUtils.toByte(right, rightOffset + result); ++result) {
        }
        return result;
    }

    public static boolean arePartsEqual(ByteBuffer buffer, int offsetLeft, int lengthLeft, int offsetRight, int lengthRight) {
        if (lengthLeft != lengthRight) {
            return false;
        }
        if (buffer.hasArray()) {
            return 0 == Bytes.compareTo(buffer.array(), buffer.arrayOffset() + offsetLeft, lengthLeft, buffer.array(), buffer.arrayOffset() + offsetRight, lengthRight);
        }
        for (int i = 0; i < lengthRight; ++i) {
            if (buffer.get(offsetLeft + i) == buffer.get(offsetRight + i)) continue;
            return false;
        }
        return true;
    }

    public static void skip(ByteBuffer buffer, int length) {
        buffer.position(buffer.position() + length);
    }

    public static void extendLimit(ByteBuffer buffer, int numBytes) {
        buffer.limit(buffer.limit() + numBytes);
    }

    public static byte[] toBytes(ByteBuffer buffer, int startPosition) {
        int originalPosition = buffer.position();
        byte[] output = new byte[buffer.limit() - startPosition];
        buffer.position(startPosition);
        buffer.get(output);
        buffer.position(originalPosition);
        return output;
    }

    public static byte[] toBytes(ByteBuffer buffer, int offset, int length) {
        byte[] output = new byte[length];
        for (int i = 0; i < length; ++i) {
            output[i] = buffer.get(offset + i);
        }
        return output;
    }

    public static boolean equals(ByteBuffer buf1, int o1, int l1, ByteBuffer buf2, int o2, int l2) {
        if (l1 == 0 || l2 == 0) {
            return l1 == l2;
        }
        if (ByteBufferUtils.toByte(buf1, o1 + l1 - 1) != ByteBufferUtils.toByte(buf2, o2 + l2 - 1)) {
            return false;
        }
        return ByteBufferUtils.compareTo(buf1, o1, l1, buf2, o2, l2) == 0;
    }

    public static int hashCode(ByteBuffer buf, int offset, int length) {
        int hash = 1;
        for (int i = offset; i < offset + length; ++i) {
            hash = 31 * hash + ByteBufferUtils.toByte(buf, i);
        }
        return hash;
    }

    public static int compareTo(ByteBuffer buf1, int o1, int l1, ByteBuffer buf2, int o2, int l2) {
        if (UNSAFE_UNALIGNED) {
            long offset2Adj;
            long offset1Adj;
            byte[] refObj1 = null;
            byte[] refObj2 = null;
            if (buf1.isDirect()) {
                offset1Adj = (long)o1 + ((DirectBuffer)((Object)buf1)).address();
            } else {
                offset1Adj = (long)(o1 + buf1.arrayOffset()) + UnsafeAccess.BYTE_ARRAY_BASE_OFFSET;
                refObj1 = buf1.array();
            }
            if (buf2.isDirect()) {
                offset2Adj = (long)o2 + ((DirectBuffer)((Object)buf2)).address();
            } else {
                offset2Adj = (long)(o2 + buf2.arrayOffset()) + UnsafeAccess.BYTE_ARRAY_BASE_OFFSET;
                refObj2 = buf2.array();
            }
            return ByteBufferUtils.compareToUnsafe(refObj1, offset1Adj, l1, refObj2, offset2Adj, l2);
        }
        int end1 = o1 + l1;
        int end2 = o2 + l2;
        int i = o1;
        for (int j = o2; i < end1 && j < end2; ++i, ++j) {
            int b;
            int a = buf1.get(i) & 0xFF;
            if (a == (b = buf2.get(j) & 0xFF)) continue;
            return a - b;
        }
        return l1 - l2;
    }

    public static boolean equals(ByteBuffer buf1, int o1, int l1, byte[] buf2, int o2, int l2) {
        if (l1 == 0 || l2 == 0) {
            return l1 == l2;
        }
        if (ByteBufferUtils.toByte(buf1, o1 + l1 - 1) != buf2[o2 + l2 - 1]) {
            return false;
        }
        return ByteBufferUtils.compareTo(buf1, o1, l1, buf2, o2, l2) == 0;
    }

    public static int compareTo(byte[] buf1, int o1, int l1, ByteBuffer buf2, int o2, int l2) {
        if (UNSAFE_UNALIGNED) {
            long offset2Adj;
            byte[] refObj2 = null;
            if (buf2.isDirect()) {
                offset2Adj = (long)o2 + ((DirectBuffer)((Object)buf2)).address();
            } else {
                offset2Adj = (long)(o2 + buf2.arrayOffset()) + UnsafeAccess.BYTE_ARRAY_BASE_OFFSET;
                refObj2 = buf2.array();
            }
            return ByteBufferUtils.compareToUnsafe(buf1, (long)o1 + UnsafeAccess.BYTE_ARRAY_BASE_OFFSET, l1, refObj2, offset2Adj, l2);
        }
        int end1 = o1 + l1;
        int end2 = o2 + l2;
        int i = o1;
        for (int j = o2; i < end1 && j < end2; ++i, ++j) {
            int a = buf1[i] & 0xFF;
            int b = buf2.get(j) & 0xFF;
            if (a == b) continue;
            return a - b;
        }
        return l1 - l2;
    }

    public static int compareTo(ByteBuffer buf1, int o1, int l1, byte[] buf2, int o2, int l2) {
        if (UNSAFE_UNALIGNED) {
            long offset1Adj;
            byte[] refObj1 = null;
            if (buf1.isDirect()) {
                offset1Adj = (long)o1 + ((DirectBuffer)((Object)buf1)).address();
            } else {
                offset1Adj = (long)(o1 + buf1.arrayOffset()) + UnsafeAccess.BYTE_ARRAY_BASE_OFFSET;
                refObj1 = buf1.array();
            }
            return ByteBufferUtils.compareToUnsafe(refObj1, offset1Adj, l1, buf2, (long)o2 + UnsafeAccess.BYTE_ARRAY_BASE_OFFSET, l2);
        }
        int end1 = o1 + l1;
        int end2 = o2 + l2;
        int i = o1;
        for (int j = o2; i < end1 && j < end2; ++i, ++j) {
            int b;
            int a = buf1.get(i) & 0xFF;
            if (a == (b = buf2[j] & 0xFF)) continue;
            return a - b;
        }
        return l1 - l2;
    }

    static int compareToUnsafe(Object obj1, long o1, int l1, Object obj2, long o2, int l2) {
        int i;
        int stride = 8;
        int minLength = Math.min(l1, l2);
        int strideLimit = minLength & 0xFFFFFFF8;
        for (i = 0; i < strideLimit; i += 8) {
            long rw;
            long lw = UnsafeAccess.theUnsafe.getLong(obj1, o1 + (long)i);
            if (lw == (rw = UnsafeAccess.theUnsafe.getLong(obj2, o2 + (long)i))) continue;
            if (!UnsafeAccess.LITTLE_ENDIAN) {
                return lw + Long.MIN_VALUE < rw + Long.MIN_VALUE ? -1 : 1;
            }
            int n = Long.numberOfTrailingZeros(lw ^ rw) & 0xFFFFFFF8;
            return (int)(lw >>> n & 0xFFL) - (int)(rw >>> n & 0xFFL);
        }
        while (i < minLength) {
            int ir;
            int il = UnsafeAccess.theUnsafe.getByte(obj1, o1 + (long)i) & 0xFF;
            if (il != (ir = UnsafeAccess.theUnsafe.getByte(obj2, o2 + (long)i) & 0xFF)) {
                return il - ir;
            }
            ++i;
        }
        return l1 - l2;
    }

    public static short toShort(ByteBuffer buffer, int offset) {
        if (UNSAFE_UNALIGNED) {
            return UnsafeAccess.toShort(buffer, offset);
        }
        return buffer.getShort(offset);
    }

    public static int toInt(ByteBuffer buffer) {
        if (UNSAFE_UNALIGNED) {
            int i = UnsafeAccess.toInt(buffer, buffer.position());
            buffer.position(buffer.position() + 4);
            return i;
        }
        return buffer.getInt();
    }

    public static int toInt(ByteBuffer buffer, int offset) {
        if (UNSAFE_UNALIGNED) {
            return UnsafeAccess.toInt(buffer, offset);
        }
        return buffer.getInt(offset);
    }

    public static int readAsInt(ByteBuffer buf, int offset, int length) {
        if (offset + length > buf.limit()) {
            throw new IllegalArgumentException("offset (" + offset + ") + length (" + length + ") exceed the limit of the buffer: " + buf.limit());
        }
        int n = 0;
        for (int i = offset; i < offset + length; ++i) {
            n <<= 8;
            n ^= ByteBufferUtils.toByte(buf, i) & 0xFF;
        }
        return n;
    }

    public static long toLong(ByteBuffer buffer, int offset) {
        if (UNSAFE_UNALIGNED) {
            return UnsafeAccess.toLong(buffer, offset);
        }
        return buffer.getLong(offset);
    }

    public static void putInt(ByteBuffer buffer, int val) {
        if (UNSAFE_UNALIGNED) {
            int newPos = UnsafeAccess.putInt(buffer, buffer.position(), val);
            buffer.position(newPos);
        } else {
            buffer.putInt(val);
        }
    }

    public static int putInt(ByteBuffer buffer, int index, int val) {
        if (UNSAFE_UNALIGNED) {
            return UnsafeAccess.putInt(buffer, index, val);
        }
        buffer.putInt(index, val);
        return index + 4;
    }

    public static double toDouble(ByteBuffer buffer, int offset) {
        return Double.longBitsToDouble(ByteBufferUtils.toLong(buffer, offset));
    }

    public static BigDecimal toBigDecimal(ByteBuffer buffer, int offset, int length) {
        if (buffer == null || length < 5 || offset + length > buffer.limit()) {
            return null;
        }
        int scale = ByteBufferUtils.toInt(buffer, offset);
        byte[] tcBytes = new byte[length - 4];
        ByteBufferUtils.copyFromBufferToArray(tcBytes, buffer, offset + 4, 0, length - 4);
        return new BigDecimal(new BigInteger(tcBytes), scale);
    }

    public static void putShort(ByteBuffer buffer, short val) {
        if (UNSAFE_UNALIGNED) {
            int newPos = UnsafeAccess.putShort(buffer, buffer.position(), val);
            buffer.position(newPos);
        } else {
            buffer.putShort(val);
        }
    }

    public static int putShort(ByteBuffer buffer, int index, short val) {
        if (UNSAFE_UNALIGNED) {
            return UnsafeAccess.putShort(buffer, index, val);
        }
        buffer.putShort(index, val);
        return index + 2;
    }

    public static int putAsShort(ByteBuffer buf, int index, int val) {
        buf.put(index + 1, (byte)val);
        buf.put(index, (byte)(val >>= 8));
        return index + 2;
    }

    public static void putLong(ByteBuffer buffer, long val) {
        if (UNSAFE_UNALIGNED) {
            int newPos = UnsafeAccess.putLong(buffer, buffer.position(), val);
            buffer.position(newPos);
        } else {
            buffer.putLong(val);
        }
    }

    public static int putLong(ByteBuffer buffer, int index, long val) {
        if (UNSAFE_UNALIGNED) {
            return UnsafeAccess.putLong(buffer, index, val);
        }
        buffer.putLong(index, val);
        return index + 8;
    }

    public static void copyFromArrayToBuffer(ByteBuffer out, byte[] in, int inOffset, int length) {
        if (out.hasArray()) {
            System.arraycopy(in, inOffset, out.array(), out.arrayOffset() + out.position(), length);
            out.position(out.position() + length);
        } else if (UNSAFE_AVAIL) {
            UnsafeAccess.copy(in, inOffset, out, out.position(), length);
            out.position(out.position() + length);
        } else {
            out.put(in, inOffset, length);
        }
    }

    public static void copyFromArrayToBuffer(ByteBuffer out, int outOffset, byte[] in, int inOffset, int length) {
        if (out.hasArray()) {
            System.arraycopy(in, inOffset, out.array(), out.arrayOffset() + outOffset, length);
        } else if (UNSAFE_AVAIL) {
            UnsafeAccess.copy(in, inOffset, out, outOffset, length);
        } else {
            ByteBuffer outDup = out.duplicate();
            outDup.position(outOffset);
            outDup.put(in, inOffset, length);
        }
    }

    public static void copyFromBufferToArray(byte[] out, ByteBuffer in, int sourceOffset, int destinationOffset, int length) {
        if (in.hasArray()) {
            System.arraycopy(in.array(), sourceOffset + in.arrayOffset(), out, destinationOffset, length);
        } else if (UNSAFE_AVAIL) {
            UnsafeAccess.copy(in, sourceOffset, out, destinationOffset, length);
        } else {
            ByteBuffer inDup = in.duplicate();
            inDup.position(sourceOffset);
            inDup.get(out, destinationOffset, length);
        }
    }

    public static byte[] copyOfRange(ByteBuffer original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        byte[] copy = new byte[newLength];
        ByteBufferUtils.copyFromBufferToArray(copy, original, from, 0, newLength);
        return copy;
    }

    public static String toStringBinary(ByteBuffer b, int off, int len) {
        StringBuilder result = new StringBuilder();
        if (off >= b.capacity()) {
            return result.toString();
        }
        if (off + len > b.capacity()) {
            len = b.capacity() - off;
        }
        for (int i = off; i < off + len; ++i) {
            int ch = b.get(i) & 0xFF;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || " `~!@#$%^&*()-_=+[]{}|;:'\",.<>/?".indexOf(ch) >= 0) {
                result.append((char)ch);
                continue;
            }
            result.append(String.format("\\x%02X", ch));
        }
        return result.toString();
    }

    public static String toStringBinary(ByteBuffer b) {
        return ByteBufferUtils.toStringBinary(b, 0, b.capacity());
    }
}

