/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.RegionMetricsBuilder;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Size;
import org.apache.hadoop.hbase.replication.ReplicationLoadSink;
import org.apache.hadoop.hbase.replication.ReplicationLoadSource;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class ServerMetricsBuilder {
    private final ServerName serverName;
    private int versionNumber;
    private long requestCountPerSecond;
    private long requestCount;
    private Size usedHeapSize = Size.ZERO;
    private Size maxHeapSize = Size.ZERO;
    private int infoServerPort;
    private List<ReplicationLoadSource> sources = Collections.emptyList();
    @Nullable
    private ReplicationLoadSink sink = null;
    private final Map<byte[], RegionMetrics> regionStatus = new TreeMap<byte[], RegionMetrics>(Bytes.BYTES_COMPARATOR);
    private final Set<String> coprocessorNames = new TreeSet<String>();
    private long reportTimestamp = System.currentTimeMillis();
    private long lastReportTimestamp = 0L;

    public static ServerMetrics of(ServerName sn) {
        return ServerMetricsBuilder.newBuilder(sn).build();
    }

    public static ServerMetrics of(ServerName sn, int versionNumber) {
        return ServerMetricsBuilder.newBuilder(sn).setVersionNumber(versionNumber).build();
    }

    public static ServerMetrics toServerMetrics(ClusterStatusProtos.LiveServerInfo serverInfo) {
        return ServerMetricsBuilder.toServerMetrics(ProtobufUtil.toServerName(serverInfo.getServer()), 0, serverInfo.getServerLoad());
    }

    public static ServerMetrics toServerMetrics(ServerName serverName, ClusterStatusProtos.ServerLoad serverLoadPB) {
        return ServerMetricsBuilder.toServerMetrics(serverName, 0, serverLoadPB);
    }

    public static ServerMetrics toServerMetrics(ServerName serverName, int versionNumber, ClusterStatusProtos.ServerLoad serverLoadPB) {
        return ServerMetricsBuilder.newBuilder(serverName).setVersionNumber(versionNumber).setRequestCountPerSecond(serverLoadPB.getNumberOfRequests()).setRequestCount(serverLoadPB.getTotalNumberOfRequests()).setInfoServerPort(serverLoadPB.getInfoServerPort()).setMaxHeapSize(new Size(serverLoadPB.getMaxHeapMB(), Size.Unit.MEGABYTE)).setUsedHeapSize(new Size(serverLoadPB.getUsedHeapMB(), Size.Unit.MEGABYTE)).setCoprocessorNames(serverLoadPB.getCoprocessorsList().stream().map(HBaseProtos.Coprocessor::getName).collect(Collectors.toList())).setRegionMetrics(serverLoadPB.getRegionLoadsList().stream().map(RegionMetricsBuilder::toRegionMetrics).collect(Collectors.toList())).setReplicationLoadSources(serverLoadPB.getReplLoadSourceList().stream().map(ProtobufUtil::toReplicationLoadSource).collect(Collectors.toList())).setReplicationLoadSink(serverLoadPB.hasReplLoadSink() ? ProtobufUtil.toReplicationLoadSink(serverLoadPB.getReplLoadSink()) : null).setReportTimestamp(serverLoadPB.getReportEndTime()).setLastReportTimestamp(serverLoadPB.getReportStartTime()).build();
    }

    public static List<HBaseProtos.Coprocessor> toCoprocessor(Collection<String> names) {
        return names.stream().map(n -> HBaseProtos.Coprocessor.newBuilder().setName((String)n).build()).collect(Collectors.toList());
    }

    public static ClusterStatusProtos.ServerLoad toServerLoad(ServerMetrics metrics) {
        ClusterStatusProtos.ServerLoad.Builder builder = ClusterStatusProtos.ServerLoad.newBuilder().setNumberOfRequests(metrics.getRequestCountPerSecond()).setTotalNumberOfRequests(metrics.getRequestCount()).setInfoServerPort(metrics.getInfoServerPort()).setMaxHeapMB((int)metrics.getMaxHeapSize().get(Size.Unit.MEGABYTE)).setUsedHeapMB((int)metrics.getUsedHeapSize().get(Size.Unit.MEGABYTE)).addAllCoprocessors(ServerMetricsBuilder.toCoprocessor(metrics.getCoprocessorNames())).addAllRegionLoads(metrics.getRegionMetrics().values().stream().map(RegionMetricsBuilder::toRegionLoad).collect(Collectors.toList())).addAllReplLoadSource(metrics.getReplicationLoadSourceList().stream().map(ProtobufUtil::toReplicationLoadSource).collect(Collectors.toList())).setReportStartTime(metrics.getLastReportTimestamp()).setReportEndTime(metrics.getReportTimestamp());
        if (metrics.getReplicationLoadSink() != null) {
            builder.setReplLoadSink(ProtobufUtil.toReplicationLoadSink(metrics.getReplicationLoadSink()));
        }
        return builder.build();
    }

    public static ServerMetricsBuilder newBuilder(ServerName sn) {
        return new ServerMetricsBuilder(sn);
    }

    private ServerMetricsBuilder(ServerName serverName) {
        this.serverName = serverName;
    }

    public ServerMetricsBuilder setVersionNumber(int versionNumber) {
        this.versionNumber = versionNumber;
        return this;
    }

    public ServerMetricsBuilder setRequestCountPerSecond(long value) {
        this.requestCountPerSecond = value;
        return this;
    }

    public ServerMetricsBuilder setRequestCount(long value) {
        this.requestCount = value;
        return this;
    }

    public ServerMetricsBuilder setUsedHeapSize(Size value) {
        this.usedHeapSize = value;
        return this;
    }

    public ServerMetricsBuilder setMaxHeapSize(Size value) {
        this.maxHeapSize = value;
        return this;
    }

    public ServerMetricsBuilder setInfoServerPort(int value) {
        this.infoServerPort = value;
        return this;
    }

    public ServerMetricsBuilder setReplicationLoadSources(List<ReplicationLoadSource> value) {
        this.sources = value;
        return this;
    }

    public ServerMetricsBuilder setReplicationLoadSink(ReplicationLoadSink value) {
        this.sink = value;
        return this;
    }

    public ServerMetricsBuilder setRegionMetrics(List<RegionMetrics> value) {
        value.forEach(v -> this.regionStatus.put(v.getRegionName(), (RegionMetrics)v));
        return this;
    }

    public ServerMetricsBuilder setCoprocessorNames(List<String> value) {
        this.coprocessorNames.addAll(value);
        return this;
    }

    public ServerMetricsBuilder setReportTimestamp(long value) {
        this.reportTimestamp = value;
        return this;
    }

    public ServerMetricsBuilder setLastReportTimestamp(long value) {
        this.lastReportTimestamp = value;
        return this;
    }

    public ServerMetrics build() {
        return new ServerMetricsImpl(this.serverName, this.versionNumber, this.requestCountPerSecond, this.requestCount, this.usedHeapSize, this.maxHeapSize, this.infoServerPort, this.sources, this.sink, this.regionStatus, this.coprocessorNames, this.reportTimestamp, this.lastReportTimestamp);
    }

    private static class ServerMetricsImpl
    implements ServerMetrics {
        private final ServerName serverName;
        private final int versionNumber;
        private final long requestCountPerSecond;
        private final long requestCount;
        private final Size usedHeapSize;
        private final Size maxHeapSize;
        private final int infoServerPort;
        private final List<ReplicationLoadSource> sources;
        @Nullable
        private final ReplicationLoadSink sink;
        private final Map<byte[], RegionMetrics> regionStatus;
        private final Set<String> coprocessorNames;
        private final long reportTimestamp;
        private final long lastReportTimestamp;

        ServerMetricsImpl(ServerName serverName, int versionNumber, long requestCountPerSecond, long requestCount, Size usedHeapSize, Size maxHeapSize, int infoServerPort, List<ReplicationLoadSource> sources, ReplicationLoadSink sink, Map<byte[], RegionMetrics> regionStatus, Set<String> coprocessorNames, long reportTimestamp, long lastReportTimestamp) {
            this.serverName = Preconditions.checkNotNull(serverName);
            this.versionNumber = versionNumber;
            this.requestCountPerSecond = requestCountPerSecond;
            this.requestCount = requestCount;
            this.usedHeapSize = Preconditions.checkNotNull(usedHeapSize);
            this.maxHeapSize = Preconditions.checkNotNull(maxHeapSize);
            this.infoServerPort = infoServerPort;
            this.sources = Preconditions.checkNotNull(sources);
            this.sink = sink;
            this.regionStatus = Preconditions.checkNotNull(regionStatus);
            this.coprocessorNames = Preconditions.checkNotNull(coprocessorNames);
            this.reportTimestamp = reportTimestamp;
            this.lastReportTimestamp = lastReportTimestamp;
        }

        @Override
        public ServerName getServerName() {
            return this.serverName;
        }

        @Override
        public int getVersionNumber() {
            return this.versionNumber;
        }

        @Override
        public long getRequestCountPerSecond() {
            return this.requestCountPerSecond;
        }

        @Override
        public long getRequestCount() {
            return this.requestCount;
        }

        @Override
        public Size getUsedHeapSize() {
            return this.usedHeapSize;
        }

        @Override
        public Size getMaxHeapSize() {
            return this.maxHeapSize;
        }

        @Override
        public int getInfoServerPort() {
            return this.infoServerPort;
        }

        @Override
        public List<ReplicationLoadSource> getReplicationLoadSourceList() {
            return Collections.unmodifiableList(this.sources);
        }

        @Override
        public ReplicationLoadSink getReplicationLoadSink() {
            return this.sink;
        }

        @Override
        public Map<byte[], RegionMetrics> getRegionMetrics() {
            return Collections.unmodifiableMap(this.regionStatus);
        }

        @Override
        public Set<String> getCoprocessorNames() {
            return Collections.unmodifiableSet(this.coprocessorNames);
        }

        @Override
        public long getReportTimestamp() {
            return this.reportTimestamp;
        }

        @Override
        public long getLastReportTimestamp() {
            return this.lastReportTimestamp;
        }

        public String toString() {
            int storeCount = 0;
            int storeFileCount = 0;
            long uncompressedStoreFileSizeMB = 0L;
            long storeFileSizeMB = 0L;
            long memStoreSizeMB = 0L;
            long storefileIndexSizeKB = 0L;
            long rootLevelIndexSizeKB = 0L;
            long readRequestsCount = 0L;
            long writeRequestsCount = 0L;
            long filteredReadRequestsCount = 0L;
            long bloomFilterSizeMB = 0L;
            long compactingCellCount = 0L;
            long compactedCellCount = 0L;
            for (RegionMetrics r : this.getRegionMetrics().values()) {
                storeCount += r.getStoreCount();
                storeFileCount += r.getStoreFileCount();
                uncompressedStoreFileSizeMB = (long)((double)uncompressedStoreFileSizeMB + r.getUncompressedStoreFileSize().get(Size.Unit.MEGABYTE));
                storeFileSizeMB = (long)((double)storeFileSizeMB + r.getStoreFileSize().get(Size.Unit.MEGABYTE));
                memStoreSizeMB = (long)((double)memStoreSizeMB + r.getMemStoreSize().get(Size.Unit.MEGABYTE));
                storefileIndexSizeKB = (long)((double)storefileIndexSizeKB + r.getStoreFileUncompressedDataIndexSize().get(Size.Unit.KILOBYTE));
                readRequestsCount += r.getReadRequestCount();
                writeRequestsCount += r.getWriteRequestCount();
                filteredReadRequestsCount += r.getFilteredReadRequestCount();
                rootLevelIndexSizeKB = (long)((double)rootLevelIndexSizeKB + r.getStoreFileRootLevelIndexSize().get(Size.Unit.KILOBYTE));
                bloomFilterSizeMB = (long)((double)bloomFilterSizeMB + r.getBloomFilterSize().get(Size.Unit.MEGABYTE));
                compactedCellCount += r.getCompactedCellCount();
                compactingCellCount += r.getCompactingCellCount();
            }
            StringBuilder sb = Strings.appendKeyValue(new StringBuilder(), "requestsPerSecond", this.getRequestCountPerSecond());
            Strings.appendKeyValue(sb, "numberOfOnlineRegions", this.getRegionMetrics().size());
            Strings.appendKeyValue(sb, "usedHeapMB", this.getUsedHeapSize());
            Strings.appendKeyValue(sb, "maxHeapMB", this.getMaxHeapSize());
            Strings.appendKeyValue(sb, "numberOfStores", storeCount);
            Strings.appendKeyValue(sb, "numberOfStorefiles", storeFileCount);
            Strings.appendKeyValue(sb, "storefileUncompressedSizeMB", uncompressedStoreFileSizeMB);
            Strings.appendKeyValue(sb, "storefileSizeMB", storeFileSizeMB);
            if (uncompressedStoreFileSizeMB != 0L) {
                Strings.appendKeyValue(sb, "compressionRatio", String.format("%.4f", Float.valueOf((float)storeFileSizeMB / (float)uncompressedStoreFileSizeMB)));
            }
            Strings.appendKeyValue(sb, "memstoreSizeMB", memStoreSizeMB);
            Strings.appendKeyValue(sb, "readRequestsCount", readRequestsCount);
            Strings.appendKeyValue(sb, "filteredReadRequestsCount", filteredReadRequestsCount);
            Strings.appendKeyValue(sb, "writeRequestsCount", writeRequestsCount);
            Strings.appendKeyValue(sb, "rootIndexSizeKB", rootLevelIndexSizeKB);
            Strings.appendKeyValue(sb, "totalStaticIndexSizeKB", storefileIndexSizeKB);
            Strings.appendKeyValue(sb, "totalStaticBloomSizeKB", bloomFilterSizeMB);
            Strings.appendKeyValue(sb, "totalCompactingKVs", compactingCellCount);
            Strings.appendKeyValue(sb, "currentCompactedKVs", compactedCellCount);
            float compactionProgressPct = Float.NaN;
            if (compactingCellCount > 0L) {
                compactionProgressPct = Float.valueOf((float)compactedCellCount / (float)compactingCellCount).floatValue();
            }
            Strings.appendKeyValue(sb, "compactionProgressPct", Float.valueOf(compactionProgressPct));
            Strings.appendKeyValue(sb, "coprocessors", this.getCoprocessorNames());
            return sb.toString();
        }
    }
}

