/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.algorithm.steps;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.schema.EdgeLabel;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.traversal.optimize.TraversalUtil;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.E;
import org.apache.tinkerpop.gremlin.structure.Edge;

public class EdgeStep {
    protected Directions direction;
    protected final Map<Id, String> labels;
    protected final Map<Id, Object> properties;
    protected final long degree;
    protected final long skipDegree;

    public EdgeStep(HugeGraph g, Directions direction) {
        this(g, direction, (List<String>)ImmutableList.of());
    }

    public EdgeStep(HugeGraph g, List<String> labels) {
        this(g, Directions.BOTH, labels);
    }

    public EdgeStep(HugeGraph g, Map<String, Object> properties) {
        this(g, Directions.BOTH, (List<String>)ImmutableList.of(), properties);
    }

    public EdgeStep(HugeGraph g, Directions direction, List<String> labels) {
        this(g, direction, labels, (Map<String, Object>)ImmutableMap.of());
    }

    public EdgeStep(HugeGraph g, Directions direction, List<String> labels, Map<String, Object> properties) {
        this(g, direction, labels, properties, Long.parseLong("10000"), 0L);
    }

    public EdgeStep(HugeGraph g, Directions direction, List<String> labels, Map<String, Object> properties, long degree, long skipDegree) {
        E.checkArgumentNotNull((Object)g, (String)"The graph can't be null", (Object[])new Object[0]);
        E.checkArgument((degree == -1L || degree > 0L ? 1 : 0) != 0, (String)"The max degree must be > 0 or == -1, but got: %s", (Object[])new Object[]{degree});
        HugeTraverser.checkSkipDegree(skipDegree, degree, -1L);
        this.direction = direction;
        HashMap<Id, String> labelIds = new HashMap<Id, String>();
        if (labels != null) {
            for (String label : labels) {
                EdgeLabel el = g.edgeLabel(label);
                labelIds.put(el.id(), label);
            }
        }
        this.labels = labelIds;
        this.properties = properties == null || properties.isEmpty() ? null : TraversalUtil.transProperties(g, properties);
        this.degree = degree;
        this.skipDegree = skipDegree;
    }

    public Directions direction() {
        return this.direction;
    }

    public Map<Id, String> labels() {
        return this.labels;
    }

    public Map<Id, Object> properties() {
        return this.properties;
    }

    public long degree() {
        return this.degree;
    }

    public long skipDegree() {
        return this.skipDegree;
    }

    public Id[] edgeLabels() {
        int elsSize = this.labels.size();
        return this.labels.keySet().toArray(new Id[elsSize]);
    }

    public void swithDirection() {
        this.direction = this.direction.opposite();
    }

    public long limit() {
        return this.skipDegree > 0L ? this.skipDegree : this.degree;
    }

    public String toString() {
        return String.format("EdgeStep{direction=%s,labels=%s,properties=%s}", this.direction, this.labels, this.properties);
    }

    public Iterator<Edge> skipSuperNodeIfNeeded(Iterator<Edge> edges) {
        return HugeTraverser.skipSuperNodeIfNeeded(edges, this.degree, this.skipDegree);
    }
}

