/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.algorithm.records;

import java.util.ArrayList;
import java.util.Stack;
import java.util.function.Function;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.traversal.algorithm.records.DoubleWayMultiPathsRecords;
import org.apache.hugegraph.traversal.algorithm.records.record.Int2IntRecord;
import org.apache.hugegraph.traversal.algorithm.records.record.Record;
import org.apache.hugegraph.traversal.algorithm.records.record.RecordType;
import org.apache.hugegraph.util.collection.CollectionFactory;
import org.apache.hugegraph.util.collection.IntMap;
import org.apache.hugegraph.util.collection.IntSet;

public class ShortestPathRecords
extends DoubleWayMultiPathsRecords {
    private final IntSet accessedVertices = CollectionFactory.newIntSet();
    private boolean pathFound;

    public ShortestPathRecords(Id sourceV, Id targetV) {
        super(RecordType.INT, false, sourceV, targetV);
        this.accessedVertices.add(this.code(sourceV));
        this.accessedVertices.add(this.code(targetV));
        this.pathFound = false;
    }

    @Override
    public HugeTraverser.PathSet findPath(Id target, Function<Id, Boolean> filter, boolean all, boolean ring) {
        assert (!ring);
        HugeTraverser.PathSet paths = new HugeTraverser.PathSet();
        int targetCode = this.code(target);
        int parentCode = this.current();
        if (this.movingForward() && this.targetContains(targetCode) || !this.movingForward() && this.sourceContains(targetCode)) {
            if (!filter.apply(target).booleanValue()) {
                return paths;
            }
            paths.add(this.movingForward() ? this.linkPath(parentCode, targetCode) : this.linkPath(targetCode, parentCode));
            this.pathFound = true;
            if (!all) {
                return paths;
            }
        }
        if (!this.pathFound && this.isNew(targetCode)) {
            this.addPath(targetCode, parentCode);
        }
        return paths;
    }

    private boolean isNew(int node) {
        return !this.currentRecord().containsKey(node) && !this.accessedVertices.contains(node);
    }

    private HugeTraverser.Path linkPath(int source, int target) {
        HugeTraverser.Path sourcePath = this.linkSourcePath(source);
        HugeTraverser.Path targetPath = this.linkTargetPath(target);
        sourcePath.reverse();
        ArrayList<Id> ids = new ArrayList<Id>(sourcePath.vertices());
        ids.addAll(targetPath.vertices());
        return new HugeTraverser.Path(ids);
    }

    private HugeTraverser.Path linkSourcePath(int source) {
        return this.linkPath(this.sourceRecords(), source);
    }

    private HugeTraverser.Path linkTargetPath(int target) {
        return this.linkPath(this.targetRecords(), target);
    }

    private HugeTraverser.Path linkPath(Stack<Record> all, int node) {
        int size = all.size();
        ArrayList<Id> ids = new ArrayList<Id>(size);
        ids.add(this.id(node));
        int value = node;
        for (int i = size - 1; i > 0; --i) {
            IntMap layer = ((Int2IntRecord)all.elementAt(i)).layer();
            value = layer.get(value);
            ids.add(this.id(value));
        }
        return new HugeTraverser.Path(ids);
    }
}

