/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job.system;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.config.CoreOptions;
import org.apache.hugegraph.structure.HugeElement;
import org.apache.hugegraph.structure.HugeIndex;

public class JobCounters {
    private final ConcurrentHashMap<String, JobCounter> jobCounters = new ConcurrentHashMap();

    public JobCounter jobCounter(HugeGraph g) {
        int batch = (Integer)g.option(CoreOptions.TASK_TTL_DELETE_BATCH);
        String graph = g.spaceGraphName();
        if (!this.jobCounters.containsKey(graph)) {
            this.jobCounters.putIfAbsent(graph, new JobCounter(batch));
        }
        return this.jobCounters.get(graph);
    }

    public static class JobCounter {
        private final AtomicInteger jobs = new AtomicInteger(0);
        private Set<HugeElement> elements = ConcurrentHashMap.newKeySet();
        private Set<HugeIndex> indexes = ConcurrentHashMap.newKeySet();
        private final int batchSize;

        public JobCounter(int batchSize) {
            this.batchSize = batchSize;
        }

        public int jobs() {
            return this.jobs.get();
        }

        public void decrement() {
            this.jobs.decrementAndGet();
        }

        public void increment() {
            this.jobs.incrementAndGet();
        }

        public Set<HugeElement> elements() {
            return this.elements;
        }

        public Set<HugeIndex> indexes() {
            return this.indexes;
        }

        public void clear(Object object) {
            if (object instanceof HugeElement) {
                this.elements = ConcurrentHashMap.newKeySet();
            } else {
                assert (object instanceof HugeIndex);
                this.indexes = ConcurrentHashMap.newKeySet();
            }
        }

        public boolean addAndTriggerDelete(Object object) {
            return object instanceof HugeElement ? this.addElementAndTriggerDelete((HugeElement)object) : this.addIndexAndTriggerDelete((HugeIndex)object);
        }

        public boolean addElementAndTriggerDelete(HugeElement element) {
            if (this.elements.size() >= this.batchSize) {
                return true;
            }
            this.elements.add(element);
            return this.elements.size() >= this.batchSize;
        }

        public boolean addIndexAndTriggerDelete(HugeIndex index) {
            if (this.indexes.size() >= this.batchSize) {
                return true;
            }
            this.indexes.add(index);
            return this.indexes.size() >= this.batchSize;
        }
    }
}

