/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job.algorithm.cent;

import java.util.Map;
import org.apache.hugegraph.job.UserJob;
import org.apache.hugegraph.job.algorithm.cent.AbstractCentAlgorithm;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.ParameterUtil;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class StressCentralityAlgorithm
extends AbstractCentAlgorithm {
    public static final String KEY_WITH_BOUNDARY = "with_boundary";

    @Override
    public String name() {
        return "stress_centrality";
    }

    @Override
    public void checkParameters(Map<String, Object> parameters) {
        super.checkParameters(parameters);
        StressCentralityAlgorithm.withBoundary(parameters);
    }

    @Override
    public Object call(UserJob<Object> job, Map<String, Object> parameters) {
        try (Traverser traverser = new Traverser(job);){
            Object object = traverser.stressCentrality(StressCentralityAlgorithm.direction(parameters), StressCentralityAlgorithm.edgeLabel(parameters), StressCentralityAlgorithm.depth(parameters), StressCentralityAlgorithm.degree(parameters), StressCentralityAlgorithm.sample(parameters), StressCentralityAlgorithm.withBoundary(parameters), StressCentralityAlgorithm.sourceLabel(parameters), StressCentralityAlgorithm.sourceSample(parameters), StressCentralityAlgorithm.sourceCLabel(parameters), StressCentralityAlgorithm.top(parameters));
            return object;
        }
    }

    protected static boolean withBoundary(Map<String, Object> parameters) {
        if (!parameters.containsKey(KEY_WITH_BOUNDARY)) {
            return false;
        }
        return ParameterUtil.parameterBoolean(parameters, KEY_WITH_BOUNDARY);
    }

    private static class Traverser
    extends AbstractCentAlgorithm.Traverser {
        public Traverser(UserJob<Object> job) {
            super(job);
        }

        public Object stressCentrality(Directions direction, String label, int depth, long degree, long sample, boolean withBoundary, String sourceLabel, long sourceSample, String sourceCLabel, long topN) {
            assert (depth > 0);
            assert (degree > 0L || degree == -1L);
            assert (topN >= 0L || topN == -1L);
            GraphTraversal t = this.constructSource(sourceLabel, sourceSample, sourceCLabel);
            t = this.constructPath(t, direction, label, degree, sample, sourceLabel, sourceCLabel);
            t = t.emit().until((Traversal)__.loops().is(P.gte((Object)depth)));
            t = this.filterNonShortestPath(t, false);
            GraphTraversal tg = this.substractPath(t, withBoundary).groupCount();
            GraphTraversal<Vertex, ?> tLimit = this.topN(tg, topN);
            return this.execute(tLimit, () -> tLimit.next());
        }
    }
}

