/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.type.HugeType;

public class LocalCounter {
    private final Map<HugeType, AtomicLong> counters = new ConcurrentHashMap<HugeType, AtomicLong>();

    public synchronized Id nextId(HugeType type) {
        AtomicLong previous;
        AtomicLong counter = this.counters.get(type);
        if (counter == null && (previous = this.counters.putIfAbsent(type, counter = new AtomicLong(0L))) != null) {
            counter = previous;
        }
        return IdGenerator.of(counter.incrementAndGet());
    }

    public long getCounter(HugeType type) {
        AtomicLong previous;
        AtomicLong counter = this.counters.get(type);
        if (counter == null && (previous = this.counters.putIfAbsent(type, counter = new AtomicLong(0L))) != null) {
            counter = previous;
        }
        return counter.longValue();
    }

    public synchronized void increaseCounter(HugeType type, long increment) {
        AtomicLong previous;
        AtomicLong counter = this.counters.get(type);
        if (counter == null && (previous = this.counters.putIfAbsent(type, counter = new AtomicLong(0L))) != null) {
            counter = previous;
        }
        long oldValue = counter.longValue();
        AtomicLong value = new AtomicLong(oldValue + increment);
        this.counters.put(type, value);
    }

    public void reset() {
        this.counters.clear();
    }
}

