/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.auth;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.HugeGraphParams;
import org.apache.hugegraph.auth.ResourceType;
import org.apache.hugegraph.auth.RolePermission;
import org.apache.hugegraph.auth.SchemaDefine;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.util.E;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class HugeUser
extends SchemaDefine.Entity {
    private static final long serialVersionUID = -8951193710873772717L;
    private String name;
    private String nickname;
    private String password;
    private String phone;
    private String email;
    private String avatar;
    private String description;
    private RolePermission role;

    public HugeUser(String name) {
        this(StringUtils.isNotEmpty((CharSequence)name) ? IdGenerator.of(name) : null, name);
    }

    public HugeUser(Id id) {
        this(id, null);
    }

    public HugeUser(Id id, String name) {
        this.id = id;
        this.name = name;
        this.role = null;
    }

    @Override
    public ResourceType type() {
        return ResourceType.USER_GROUP;
    }

    @Override
    public String label() {
        return P.USER;
    }

    @Override
    public String name() {
        return this.name;
    }

    public String nickname() {
        return this.nickname;
    }

    public void nickname(String nickname) {
        this.nickname = nickname;
    }

    public String password() {
        return this.password;
    }

    public void password(String password) {
        this.password = password;
    }

    public String phone() {
        return this.phone;
    }

    public void phone(String phone) {
        this.phone = phone;
    }

    public String email() {
        return this.email;
    }

    public void email(String email) {
        this.email = email;
    }

    public String avatar() {
        return this.avatar;
    }

    public void avatar(String avatar) {
        this.avatar = avatar;
    }

    public String description() {
        return this.description;
    }

    public void description(String description) {
        this.description = description;
    }

    public RolePermission role() {
        return this.role;
    }

    public void role(RolePermission role) {
        this.role = role;
    }

    public String toString() {
        return String.format("HugeUser(%s)%s", this.id, this.asMap());
    }

    @Override
    protected boolean property(String key, Object value) {
        if (super.property(key, value)) {
            return true;
        }
        switch (key) {
            case "~user_name": {
                this.name = (String)value;
                break;
            }
            case "~user_password": {
                this.password = (String)value;
                break;
            }
            case "~user_phone": {
                this.phone = (String)value;
                break;
            }
            case "~user_email": {
                this.email = (String)value;
                break;
            }
            case "~user_avatar": {
                this.avatar = (String)value;
                break;
            }
            case "~user_description": {
                this.description = (String)value;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported key: " + key));
            }
        }
        return true;
    }

    @Override
    protected Object[] asArray() {
        E.checkState((this.name != null ? 1 : 0) != 0, (String)"User name can't be null", (Object[])new Object[0]);
        E.checkState((this.password != null ? 1 : 0) != 0, (String)"User password can't be null", (Object[])new Object[0]);
        ArrayList<Object> list = new ArrayList<Object>(18);
        list.add(T.label);
        list.add(P.USER);
        list.add("~user_name");
        list.add(this.name);
        list.add("~user_password");
        list.add(this.password);
        if (this.phone != null) {
            list.add("~user_phone");
            list.add(this.phone);
        }
        if (this.email != null) {
            list.add("~user_email");
            list.add(this.email);
        }
        if (this.avatar != null) {
            list.add("~user_avatar");
            list.add(this.avatar);
        }
        if (this.description != null) {
            list.add("~user_description");
            list.add(this.description);
        }
        return super.asArray(list);
    }

    @Override
    public Map<String, Object> asMap() {
        E.checkState((this.name != null ? 1 : 0) != 0, (String)"User name can't be null", (Object[])new Object[0]);
        E.checkState((this.password != null ? 1 : 0) != 0, (String)"User password can't be null", (Object[])new Object[0]);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(Graph.Hidden.unHide((String)"~user_name"), this.name);
        map.put(Graph.Hidden.unHide((String)"~user_password"), this.password);
        if (this.phone != null) {
            map.put(Graph.Hidden.unHide((String)"~user_phone"), this.phone);
        }
        if (this.email != null) {
            map.put(Graph.Hidden.unHide((String)"~user_email"), this.email);
        }
        if (this.avatar != null) {
            map.put(Graph.Hidden.unHide((String)"~user_avatar"), this.avatar);
        }
        if (this.description != null) {
            map.put(Graph.Hidden.unHide((String)"~user_description"), this.description);
        }
        return super.asMap(map);
    }

    public static HugeUser fromVertex(Vertex vertex) {
        HugeUser user = new HugeUser((Id)vertex.id());
        return HugeUser.fromVertex(vertex, user);
    }

    public static Schema schema(HugeGraphParams graph) {
        return new Schema(graph);
    }

    public static HugeUser fromMap(Map<String, Object> map) {
        HugeUser user = new HugeUser("");
        return HugeUser.fromMap(map, user);
    }

    public static final class Schema
    extends SchemaDefine {
        public Schema(HugeGraphParams graph) {
            super(graph, P.USER);
        }

        @Override
        public void initSchemaIfNeeded() {
            if (this.existVertexLabel(this.label)) {
                return;
            }
            String[] properties = this.initProperties();
            VertexLabel label = (VertexLabel)this.schema().vertexLabel(this.label).properties(properties).usePrimaryKeyId().primaryKeys("~user_name").nullableKeys("~user_phone", "~user_email", "~user_avatar", "~user_description").enableLabelIndex(true).build();
            this.graph.schemaTransaction().addVertexLabel(label);
        }

        private String[] initProperties() {
            ArrayList<String> props = new ArrayList<String>();
            props.add(this.createPropertyKey("~user_name"));
            props.add(this.createPropertyKey("~user_password"));
            props.add(this.createPropertyKey("~user_phone"));
            props.add(this.createPropertyKey("~user_email"));
            props.add(this.createPropertyKey("~user_avatar"));
            props.add(this.createPropertyKey("~user_description"));
            return super.initProperties(props);
        }
    }

    public static final class P {
        public static final String USER;
        public static final String USER_HIDDEN;
        public static final String ID;
        public static final String LABEL;
        public static final String NAME = "~user_name";
        public static final String PASSWORD = "~user_password";
        public static final String PHONE = "~user_phone";
        public static final String EMAIL = "~user_email";
        public static final String AVATAR = "~user_avatar";
        public static final String DESCRIPTION = "~user_description";

        public static String unhide(String key) {
            String prefix = Graph.Hidden.hide((String)"user_");
            if (key.startsWith(prefix)) {
                return key.substring(prefix.length());
            }
            return key;
        }

        static {
            USER_HIDDEN = USER = Graph.Hidden.hide((String)"user");
            ID = T.id.getAccessor();
            LABEL = T.label.getAccessor();
        }
    }
}

