/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.auth;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.HugeGraphParams;
import org.apache.hugegraph.auth.ResourceType;
import org.apache.hugegraph.auth.SchemaDefine;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.util.E;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class HugeGroup
extends SchemaDefine.Entity {
    private static final long serialVersionUID = 2330399818352242686L;
    public static final String ID_PREFIX = "group-";
    private String name;
    private String nickname;
    private String description;

    public HugeGroup(String name) {
        this(StringUtils.isNotEmpty((CharSequence)name) ? IdGenerator.of(name) : null, name);
    }

    public HugeGroup(Id id) {
        this(id, null);
    }

    public HugeGroup(Id id, String name) {
        this.id = id;
        this.name = name;
        this.description = null;
    }

    public static boolean isGroup(String id) {
        return StringUtils.isNotEmpty((CharSequence)id) && id.startsWith(ID_PREFIX);
    }

    @Override
    public ResourceType type() {
        return ResourceType.USER_GROUP;
    }

    @Override
    public String label() {
        return P.GROUP;
    }

    @Override
    public String name() {
        return this.name;
    }

    public String nickname() {
        return this.nickname;
    }

    public void nickname(String nickname) {
        this.nickname = nickname;
    }

    public String description() {
        return this.description;
    }

    public void description(String description) {
        this.description = description;
    }

    public String toString() {
        return String.format("HugeGroup(%s)%s", this.id, this.asMap());
    }

    @Override
    protected boolean property(String key, Object value) {
        if (super.property(key, value)) {
            return true;
        }
        switch (key) {
            case "~group_name": {
                this.name = (String)value;
                break;
            }
            case "~group_description": {
                this.description = (String)value;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported key: " + key));
            }
        }
        return true;
    }

    @Override
    protected Object[] asArray() {
        E.checkState((this.name != null ? 1 : 0) != 0, (String)"Group name can't be null", (Object[])new Object[0]);
        ArrayList<Object> list = new ArrayList<Object>(12);
        list.add(T.label);
        list.add(P.GROUP);
        list.add("~group_name");
        list.add(this.name);
        if (this.description != null) {
            list.add("~group_description");
            list.add(this.description);
        }
        return super.asArray(list);
    }

    @Override
    public Map<String, Object> asMap() {
        E.checkState((this.name != null ? 1 : 0) != 0, (String)"Group name can't be null", (Object[])new Object[0]);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(Graph.Hidden.unHide((String)"~group_name"), this.name);
        if (this.description != null) {
            map.put(Graph.Hidden.unHide((String)"~group_description"), this.description);
        }
        return super.asMap(map);
    }

    public static HugeGroup fromVertex(Vertex vertex) {
        HugeGroup group = new HugeGroup((Id)vertex.id());
        return HugeGroup.fromVertex(vertex, group);
    }

    public static Schema schema(HugeGraphParams graph) {
        return new Schema(graph);
    }

    public static HugeGroup fromMap(Map<String, Object> map) {
        HugeGroup group = new HugeGroup("");
        return HugeGroup.fromMap(map, group);
    }

    public static final class Schema
    extends SchemaDefine {
        public Schema(HugeGraphParams graph) {
            super(graph, P.GROUP);
        }

        @Override
        public void initSchemaIfNeeded() {
            if (this.existVertexLabel(this.label)) {
                return;
            }
            String[] properties = this.initProperties();
            VertexLabel label = (VertexLabel)this.schema().vertexLabel(this.label).properties(properties).usePrimaryKeyId().primaryKeys("~group_name").nullableKeys("~group_description").enableLabelIndex(true).build();
            this.graph.schemaTransaction().addVertexLabel(label);
        }

        private String[] initProperties() {
            ArrayList<String> props = new ArrayList<String>();
            props.add(this.createPropertyKey("~group_name"));
            props.add(this.createPropertyKey("~group_description"));
            return super.initProperties(props);
        }
    }

    public static final class P {
        public static final String GROUP = Graph.Hidden.hide((String)"group");
        public static final String ID = T.id.getAccessor();
        public static final String LABEL = T.label.getAccessor();
        public static final String NAME = "~group_name";
        public static final String DESCRIPTION = "~group_description";

        public static String unhide(String key) {
            String prefix = Graph.Hidden.hide((String)"group_");
            if (key.startsWith(prefix)) {
                return key.substring(prefix.length());
            }
            return key;
        }
    }
}

