/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.metrics;

import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import org.apache.hugegraph.store.node.metrics.ProcfsReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ProcfsEntry {
    private static final Logger log = LoggerFactory.getLogger(ProcfsEntry.class);
    private final Object lock = new Object();
    private final ProcfsReader reader;
    private long lastHandle = -1L;

    protected ProcfsEntry(ProcfsReader reader) {
        this.reader = Objects.requireNonNull(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void collect() {
        Object object = this.lock;
        synchronized (object) {
            try {
                ProcfsReader.ReadResult result = this.reader.read();
                if (result != null && (this.lastHandle == -1L || this.lastHandle != result.getReadTime())) {
                    this.reset();
                    this.handle((Collection)result.getLines());
                    this.lastHandle = result.getReadTime();
                }
            }
            catch (IOException e) {
                this.reset();
                log.warn("Failed reading '" + String.valueOf(this.reader.getEntryPath()) + "'!", (Throwable)e);
            }
        }
    }

    protected abstract void reset();

    protected abstract void handle(Collection<String> var1);
}

