/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.grpc.query.stages;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hugegraph.id.Id;
import org.apache.hugegraph.rocksdb.access.RocksDBSession;
import org.apache.hugegraph.store.node.grpc.query.QueryStage;
import org.apache.hugegraph.store.node.grpc.query.QueryUtil;
import org.apache.hugegraph.store.node.grpc.query.model.PipelineResult;
import org.apache.hugegraph.store.node.grpc.query.model.PipelineResultType;
import org.apache.hugegraph.structure.BaseElement;

public class ProjectionStage
implements QueryStage {
    private Set<Id> propertySet;
    private boolean removeAllProperty;

    public void init(Object ... objects) {
        this.propertySet = new HashSet(QueryUtil.fromStringBytes((List)((List)objects[0])));
        this.removeAllProperty = (Boolean)objects[1];
    }

    public PipelineResult handle(PipelineResult result) {
        if (result == null) {
            return null;
        }
        if (result.getResultType() == PipelineResultType.HG_ELEMENT) {
            BaseElement element = result.getElement();
            for (Map.Entry id : element.getProperties().entrySet()) {
                if (this.propertySet.contains(id.getKey()) && !this.removeAllProperty) continue;
                element.removeProperty((Id)id.getKey());
            }
            return result;
        }
        if (result.getResultType() == PipelineResultType.BACKEND_COLUMN && this.removeAllProperty) {
            RocksDBSession.BackendColumn column = result.getColumn();
            column.value = new byte[0];
        }
        return result;
    }

    public String getName() {
        return "PROJECTION_STAGE";
    }

    public void close() {
        this.propertySet.clear();
    }
}

