/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.grpc;

import com.google.protobuf.ByteString;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import org.apache.hugegraph.rocksdb.access.RocksDBSession;
import org.apache.hugegraph.rocksdb.access.ScanIterator;
import org.apache.hugegraph.store.grpc.common.Kv;
import org.apache.hugegraph.store.grpc.stream.KvPageRes;
import org.apache.hugegraph.store.grpc.stream.ScanStreamReq;
import org.apache.hugegraph.store.node.grpc.HgStoreWrapperEx;
import org.apache.hugegraph.store.node.grpc.ScanQuery;
import org.apache.hugegraph.store.node.grpc.ScanUtil;
import org.apache.hugegraph.store.node.util.HgGrpc;
import org.apache.hugegraph.store.node.util.HgStoreNodeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanOneShotResponse {
    private static final Logger log = LoggerFactory.getLogger(ScanOneShotResponse.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scanOneShot(ScanStreamReq request, StreamObserver<KvPageRes> responseObserver, HgStoreWrapperEx wrapper) {
        KvPageRes.Builder resBuilder = KvPageRes.newBuilder();
        Kv.Builder kvBuilder = Kv.newBuilder();
        ScanIterator iterator = ScanUtil.getIterator((ScanQuery)ScanUtil.toSq((ScanStreamReq)request), (HgStoreWrapperEx)wrapper);
        long limit = request.getLimit();
        if (limit <= 0L) {
            responseObserver.onError((Throwable)HgGrpc.toErr((String)"limit<=0, please to invoke stream scan."));
            return;
        }
        int count = 0;
        try {
            while (iterator.hasNext() && (long)(++count) <= limit) {
                RocksDBSession.BackendColumn col = (RocksDBSession.BackendColumn)iterator.next();
                resBuilder.addData(kvBuilder.setKey(ByteString.copyFrom((byte[])col.name)).setValue(ByteString.copyFrom((byte[])col.value)).setCode(HgStoreNodeUtil.toInt((byte[])iterator.position())));
            }
            responseObserver.onNext((Object)resBuilder.build());
            responseObserver.onCompleted();
        }
        catch (Throwable t) {
            String msg = "an exception occurred during data scanning";
            responseObserver.onError((Throwable)HgGrpc.toErr((Status)Status.INTERNAL, (String)msg, (Throwable)t));
        }
        finally {
            iterator.close();
        }
    }
}

