/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.grpc;

import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hugegraph.pd.common.KVPair;
import org.apache.hugegraph.rocksdb.access.ScanIterator;
import org.apache.hugegraph.store.node.grpc.QueryCondition;
import org.apache.hugegraph.store.node.util.HgAssert;
import org.apache.hugegraph.store.node.util.HgStoreConst;

@NotThreadSafe
public final class BatchScanIterator
implements ScanIterator {
    private final Supplier<KVPair<QueryCondition, ScanIterator>> batchSupplier;
    private final Supplier<Long> limitSupplier;
    private final AtomicBoolean closed = new AtomicBoolean();
    private ScanIterator iterator;
    private boolean hasNext = false;
    private long curCount;
    private long curLimit;

    private BatchScanIterator(Supplier<KVPair<QueryCondition, ScanIterator>> iteratorSupplier, Supplier<Long> limitSupplier) {
        this.batchSupplier = iteratorSupplier;
        this.limitSupplier = limitSupplier;
    }

    public static BatchScanIterator of(Supplier<KVPair<QueryCondition, ScanIterator>> iteratorSupplier, Supplier<Long> limitSupplier) {
        HgAssert.isArgumentNotNull(iteratorSupplier, (String)"iteratorSupplier");
        HgAssert.isArgumentNotNull(limitSupplier, (String)"limitSupplier");
        return new BatchScanIterator(iteratorSupplier, limitSupplier);
    }

    private ScanIterator getIterator() {
        ScanIterator buf;
        int count = 0;
        this.curCount = 0L;
        while ((buf = (ScanIterator)((KVPair)this.batchSupplier.get()).getValue()) != null) {
            if (!buf.hasNext()) {
                buf.close();
                buf = null;
            }
            if (++count == Integer.MAX_VALUE) {
                throw new RuntimeException("Do loop times more than Integer.MAX_VALUE");
            }
            if (buf == null) continue;
        }
        if (buf != null) {
            Long limit = (Long)this.limitSupplier.get();
            this.curLimit = limit == null || limit <= 0L ? Integer.MAX_VALUE : limit;
        }
        return buf;
    }

    public boolean hasNext() {
        if (this.iterator == null) {
            this.iterator = this.getIterator();
        } else if (!this.iterator.hasNext()) {
            this.iterator.close();
            this.iterator = this.getIterator();
        } else if (this.curCount == this.curLimit) {
            this.iterator.close();
            this.iterator = this.getIterator();
        }
        if (this.iterator == null) {
            return false;
        }
        this.hasNext = true;
        return true;
    }

    public <T> T next() {
        if (this.hasNext) {
            this.hasNext = false;
        } else if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.curCount;
        return (T)this.iterator.next();
    }

    public void close() {
        if (!this.closed.getAndSet(true) && this.iterator != null) {
            this.iterator.close();
        }
    }

    public boolean isValid() {
        throw new UnsupportedOperationException();
    }

    public long count() {
        throw new UnsupportedOperationException();
    }

    public byte[] position() {
        if (this.iterator != null) {
            return this.iterator.position();
        }
        return HgStoreConst.EMPTY_BYTES;
    }
}

