/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.corpus;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apdplat.word.segmentation.Word;
import org.apdplat.word.util.AutoDetector;
import org.apdplat.word.util.DoubleArrayGenericTrie;
import org.apdplat.word.util.ResourceLoader;
import org.apdplat.word.util.WordConfTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Trigram {
    private static final Logger LOGGER = LoggerFactory.getLogger(Trigram.class);
    private static final DoubleArrayGenericTrie DOUBLE_ARRAY_GENERIC_TRIE = new DoubleArrayGenericTrie(WordConfTools.getInt("trigram.double.array.trie.size", 9800000));
    private static int maxFrequency = 0;

    public static void reload() {
        AutoDetector.loadAndWatch(new ResourceLoader(){

            @Override
            public void clear() {
                DOUBLE_ARRAY_GENERIC_TRIE.clear();
            }

            @Override
            public void load(List<String> list) {
                LOGGER.info("\u521d\u59cb\u5316trigram");
                HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                for (String string : list) {
                    try {
                        this.addLine(string, hashMap);
                    }
                    catch (Exception exception) {
                        LOGGER.error("\u9519\u8bef\u7684trigram\u6570\u636e\uff1a" + string);
                    }
                }
                int n = hashMap.size();
                DOUBLE_ARRAY_GENERIC_TRIE.putAll(hashMap);
                LOGGER.info("trigram\u521d\u59cb\u5316\u5b8c\u6bd5\uff0ctrigram\u6570\u636e\u6761\u6570\uff1a" + n);
            }

            @Override
            public void add(String string) {
                throw new RuntimeException("not yet support menthod!");
            }

            private void addLine(String string, Map<String, Integer> map) {
                String[] stringArray = string.split("\\s+");
                int n = Integer.parseInt(stringArray[1]);
                if (n > maxFrequency) {
                    maxFrequency = n;
                }
                map.put(stringArray[0], n);
            }

            @Override
            public void remove(String string) {
                throw new RuntimeException("not yet support menthod!");
            }
        }, WordConfTools.get("trigram.path", "classpath:trigram.txt"));
    }

    public static int getMaxFrequency() {
        return maxFrequency;
    }

    public static Map<List<Word>, Float> trigram(List<Word> ... listArray) {
        HashMap<List<Word>, Float> hashMap = new HashMap<List<Word>, Float>();
        for (List<Word> list : listArray) {
            if (hashMap.get(list) != null) continue;
            float f = 0.0f;
            if (list.size() > 2) {
                for (int i = 0; i < list.size() - 2; ++i) {
                    String string;
                    String string2;
                    String string3 = list.get(i).getText();
                    float f2 = Trigram.getScore(string3, string2 = list.get(i + 1).getText(), string = list.get(i + 2).getText());
                    if (!(f2 > 0.0f)) continue;
                    f += f2;
                }
            }
            hashMap.put(list, Float.valueOf(f));
        }
        return hashMap;
    }

    public static float trigram(List<Word> list) {
        if (list.size() > 2) {
            float f = 0.0f;
            for (int i = 0; i < list.size() - 2; ++i) {
                f += Trigram.getScore(list.get(i).getText(), list.get(i + 1).getText(), list.get(i + 2).getText());
            }
            return f;
        }
        return 0.0f;
    }

    public static float getScore(String string, String string2, String string3) {
        int n = Trigram.getFrequency(string, string2, string3);
        float f = (float)n / (float)maxFrequency;
        if (LOGGER.isDebugEnabled() && f > 0.0f) {
            LOGGER.debug("\u4e09\u5143\u6a21\u578b " + string + ":" + string2 + ":" + string3 + " \u83b7\u5f97\u5206\u503c\uff1a" + f);
        }
        return f;
    }

    public static int getFrequency(String string, String string2, String string3) {
        Integer n = DOUBLE_ARRAY_GENERIC_TRIE.get(string + ":" + string2 + ":" + string3);
        if (n == null) {
            return 0;
        }
        return n;
    }

    static {
        Trigram.reload();
    }
}

