/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traversers;

import com.codahale.metrics.annotation.Timed;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.graph.EdgeAPI;
import org.apache.hugegraph.api.graph.VertexAPI;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.traversal.algorithm.SubGraphTraverser;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;

@Path(value="graphspaces/{graphspace}/graphs/{graph}/traversers/rings")
@Singleton
@Tag(name="RingsAPI")
public class RingsAPI
extends API {
    private static final Logger LOG = Log.logger(RingsAPI.class);

    @GET
    @Timed
    @Produces(value={"application/json;charset=UTF-8"})
    public String get(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @PathParam(value="graph") String graph, @QueryParam(value="source") String sourceV, @QueryParam(value="direction") String direction, @QueryParam(value="label") String edgeLabel, @QueryParam(value="max_depth") int depth, @QueryParam(value="source_in_ring") @DefaultValue(value="true") boolean sourceInRing, @QueryParam(value="max_degree") @DefaultValue(value="10000") long maxDegree, @QueryParam(value="capacity") @DefaultValue(value="10000000") long capacity, @QueryParam(value="limit") @DefaultValue(value="10") int limit, @QueryParam(value="with_vertex") @DefaultValue(value="false") boolean withVertex, @QueryParam(value="with_edge") @DefaultValue(value="false") boolean withEdge) {
        Iterator iterVertex;
        LOG.debug("Graph [{}] get rings paths reachable from '{}' with direction '{}', edge label '{}', max depth '{}', source in ring '{}', max degree '{}', capacity '{}', limit '{}', with_vertex '{}' and with_edge '{}'", new Object[]{graph, sourceV, direction, edgeLabel, depth, sourceInRing, maxDegree, capacity, limit, withVertex, withEdge});
        API.ApiMeasurer measure = new API.ApiMeasurer();
        Id source = VertexAPI.checkAndParseVertexId(sourceV);
        Directions dir = Directions.convert((Direction)EdgeAPI.parseDirection(direction));
        HugeGraph g = RingsAPI.graph(manager, graphSpace, graph);
        SubGraphTraverser traverser = new SubGraphTraverser(g);
        HugeTraverser.PathSet paths = traverser.rings(source, dir, edgeLabel, depth, sourceInRing, maxDegree, capacity, (long)limit);
        measure.addIterCount(traverser.vertexIterCounter.get(), traverser.edgeIterCounter.get());
        HashSet vertexIds = new HashSet();
        for (HugeTraverser.Path path : paths) {
            vertexIds.addAll(path.vertices());
        }
        if (withVertex && !vertexIds.isEmpty()) {
            iterVertex = g.vertices(vertexIds.toArray());
            measure.addIterCount(vertexIds.size(), 0L);
        } else {
            iterVertex = vertexIds.iterator();
        }
        Set edges = paths.getEdges();
        Iterator iterEdge = withEdge && !edges.isEmpty() ? edges.iterator() : HugeTraverser.EdgeRecord.getEdgeIds((Set)edges).iterator();
        return manager.serializer((Graph)g, measure.measures()).writePaths("rings", (Collection<HugeTraverser.Path>)paths, false, iterVertex, iterEdge);
    }
}

