/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.arrow;

import org.apache.arrow.memory.RootAllocator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;

public enum RootAllocatorFactory {
    INSTANCE;

    private RootAllocator rootAllocator;

    public synchronized RootAllocator getRootAllocator(Configuration conf) {
        if (this.rootAllocator == null) {
            long limit = HiveConf.getLongVar(conf, HiveConf.ConfVars.HIVE_ARROW_ROOT_ALLOCATOR_LIMIT);
            this.rootAllocator = new RootAllocator(limit);
        }
        return this.rootAllocator;
    }

    public synchronized RootAllocator getOrCreateRootAllocator(long arrowAllocatorLimit) {
        if (this.rootAllocator == null) {
            this.rootAllocator = new RootAllocator(arrowAllocatorLimit);
        }
        return this.rootAllocator;
    }
}

