/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell.find;

import java.io.IOException;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.fs.shell.find.Expression;
import org.apache.hadoop.fs.shell.find.FindOptions;

public abstract class BaseExpression
implements Expression,
Configurable {
    private String[] usage = new String[]{"Not yet implemented"};
    private String[] help = new String[]{"Not yet implemented"};
    private FindOptions options;
    private Configuration conf;
    private LinkedList<String> arguments = new LinkedList();
    private LinkedList<Expression> children = new LinkedList();

    protected void setUsage(String[] usage) {
        this.usage = usage;
    }

    protected void setHelp(String[] help) {
        this.help = help;
    }

    @Override
    public String[] getUsage() {
        return this.usage;
    }

    @Override
    public String[] getHelp() {
        return this.help;
    }

    @Override
    public void setOptions(FindOptions options) throws IOException {
        this.options = options;
        for (Expression child : this.getChildren()) {
            child.setOptions(options);
        }
    }

    @Override
    public void prepare() throws IOException {
        for (Expression child : this.getChildren()) {
            child.prepare();
        }
    }

    @Override
    public void finish() throws IOException {
        for (Expression child : this.getChildren()) {
            child.finish();
        }
    }

    protected FindOptions getOptions() {
        return this.options == null ? new FindOptions() : this.options;
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("(");
        boolean firstArg = true;
        for (String arg : this.getArguments()) {
            if (!firstArg) {
                sb.append(",");
            } else {
                firstArg = false;
            }
            sb.append(arg);
        }
        sb.append(";");
        firstArg = true;
        for (Expression child : this.getChildren()) {
            if (!firstArg) {
                sb.append(",");
            } else {
                firstArg = false;
            }
            sb.append(child.toString());
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean isAction() {
        for (Expression child : this.getChildren()) {
            if (!child.isAction()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isOperator() {
        return false;
    }

    protected List<String> getArguments() {
        return this.arguments;
    }

    protected String getArgument(int position) throws IOException {
        if (position > this.arguments.size()) {
            throw new IOException("Missing argument at " + position);
        }
        String argument = this.arguments.get(position - 1);
        if (argument == null) {
            throw new IOException("Null argument at position " + position);
        }
        return argument;
    }

    protected List<Expression> getChildren() {
        return this.children;
    }

    @Override
    public int getPrecedence() {
        return 0;
    }

    @Override
    public void addChildren(Deque<Expression> exprs) {
    }

    protected void addChildren(Deque<Expression> exprs, int count) {
        for (int i = 0; i < count; ++i) {
            this.addChild(exprs.pop());
        }
    }

    private void addChild(Expression expr) {
        this.children.push(expr);
    }

    @Override
    public void addArguments(Deque<String> args) {
    }

    protected void addArguments(Deque<String> args, int count) {
        for (int i = 0; i < count; ++i) {
            this.addArgument(args.pop());
        }
    }

    protected void addArgument(String arg) {
        this.arguments.add(arg);
    }

    protected FileStatus getFileStatus(PathData item, int depth) throws IOException {
        FileStatus fileStatus = item.stat;
        if (fileStatus.isSymlink() && (this.options.isFollowLink() || this.options.isFollowArgLink() && depth == 0)) {
            Path linkedFile = item.fs.resolvePath(fileStatus.getSymlink());
            fileStatus = this.getFileSystem(item).getFileStatus(linkedFile);
        }
        return fileStatus;
    }

    protected Path getPath(PathData item) throws IOException {
        return item.path;
    }

    protected FileSystem getFileSystem(PathData item) throws IOException {
        return item.fs;
    }
}

