/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json;

import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import org.glassfish.json.JsonProviderImpl;
import org.glassfish.json.JsonWriterImpl;

class JsonWriterFactoryImpl
implements JsonWriterFactory {
    private final Map<String, ?> config;

    JsonWriterFactoryImpl(Map<String, ?> config) {
        boolean prettyPrinting = config != null && JsonProviderImpl.isPrettyPrintingEnabled(config);
        HashMap<String, Boolean> providerConfig = new HashMap<String, Boolean>();
        if (prettyPrinting) {
            providerConfig.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
        }
        this.config = Collections.unmodifiableMap(providerConfig);
    }

    @Override
    public JsonWriter createWriter(Writer writer) {
        return new JsonWriterImpl(writer, this.config);
    }

    @Override
    public JsonWriter createWriter(OutputStream out) {
        return new JsonWriterImpl(out, this.config);
    }

    @Override
    public JsonWriter createWriter(OutputStream out, Charset charset) {
        return new JsonWriterImpl(out, charset, this.config);
    }

    @Override
    public Map<String, ?> getConfigInUse() {
        return this.config;
    }
}

